/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.player.Animation;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundAnimatePacket
implements Packet {
    private final int entityId;
    @NonNull
    private final Animation animation;

    public ClientboundAnimatePacket(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.animation = MagicValues.key(Animation.class, in.readUnsignedByte());
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeByte(MagicValues.value(Integer.class, (Object)this.animation).intValue());
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public Animation getAnimation() {
        return this.animation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundAnimatePacket)) {
            return false;
        }
        ClientboundAnimatePacket other = (ClientboundAnimatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        Animation this$animation = this.getAnimation();
        Animation other$animation = other.getAnimation();
        return !(this$animation == null ? other$animation != null : !((Object)((Object)this$animation)).equals((Object)other$animation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundAnimatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        Animation $animation = this.getAnimation();
        result = result * 59 + ($animation == null ? 43 : ((Object)((Object)$animation)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundAnimatePacket(entityId=" + this.getEntityId() + ", animation=" + (Object)((Object)this.getAnimation()) + ")";
    }

    public ClientboundAnimatePacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundAnimatePacket(entityId, this.animation);
    }

    public ClientboundAnimatePacket withAnimation(@NonNull Animation animation) {
        if (animation == null) {
            throw new NullPointerException("animation is marked non-null but is null");
        }
        return this.animation == animation ? this : new ClientboundAnimatePacket(this.entityId, animation);
    }

    public ClientboundAnimatePacket(int entityId, @NonNull Animation animation) {
        if (animation == null) {
            throw new NullPointerException("animation is marked non-null but is null");
        }
        this.entityId = entityId;
        this.animation = animation;
    }
}

