/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.UnlockRecipesAction;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ClientboundRecipePacket
implements Packet {
    @NonNull
    private final UnlockRecipesAction action;
    @NonNull
    private final String[] recipes;
    private final boolean openCraftingBook;
    private final boolean activateCraftingFiltering;
    private final boolean openSmeltingBook;
    private final boolean activateSmeltingFiltering;
    private final boolean openBlastingBook;
    private final boolean activateBlastingFiltering;
    private final boolean openSmokingBook;
    private final boolean activateSmokingFiltering;
    private final String[] alreadyKnownRecipes;

    public ClientboundRecipePacket(@NonNull String[] recipes, boolean openCraftingBook, boolean activateCraftingFiltering, boolean openSmeltingBook, boolean activateSmeltingFiltering, boolean openBlastingBook, boolean activateBlastingFiltering, boolean openSmokingBook, boolean activateSmokingFiltering, @NonNull UnlockRecipesAction action) {
        if (recipes == null) {
            throw new NullPointerException("recipes is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (action != UnlockRecipesAction.ADD && action != UnlockRecipesAction.REMOVE) {
            throw new IllegalArgumentException("Action must be ADD or REMOVE.");
        }
        this.action = action;
        this.recipes = Arrays.copyOf(recipes, recipes.length);
        this.openCraftingBook = openCraftingBook;
        this.activateCraftingFiltering = activateCraftingFiltering;
        this.openSmeltingBook = openSmeltingBook;
        this.activateSmeltingFiltering = activateSmeltingFiltering;
        this.openBlastingBook = openBlastingBook;
        this.activateBlastingFiltering = activateBlastingFiltering;
        this.openSmokingBook = openSmokingBook;
        this.activateSmokingFiltering = activateSmokingFiltering;
        this.alreadyKnownRecipes = null;
    }

    public ClientboundRecipePacket(@NonNull String[] recipes, boolean openCraftingBook, boolean activateCraftingFiltering, boolean openSmeltingBook, boolean activateSmeltingFiltering, boolean openBlastingBook, boolean activateBlastingFiltering, boolean openSmokingBook, boolean activateSmokingFiltering, @NonNull String[] alreadyKnownRecipes) {
        if (recipes == null) {
            throw new NullPointerException("recipes is marked non-null but is null");
        }
        if (alreadyKnownRecipes == null) {
            throw new NullPointerException("alreadyKnownRecipes is marked non-null but is null");
        }
        this.action = UnlockRecipesAction.INIT;
        this.recipes = Arrays.copyOf(recipes, recipes.length);
        this.openCraftingBook = openCraftingBook;
        this.activateCraftingFiltering = activateCraftingFiltering;
        this.openSmeltingBook = openSmeltingBook;
        this.activateSmeltingFiltering = activateSmeltingFiltering;
        this.openBlastingBook = openBlastingBook;
        this.activateBlastingFiltering = activateBlastingFiltering;
        this.openSmokingBook = openSmokingBook;
        this.activateSmokingFiltering = activateSmokingFiltering;
        this.alreadyKnownRecipes = Arrays.copyOf(alreadyKnownRecipes, alreadyKnownRecipes.length);
    }

    public ClientboundRecipePacket(NetInput in) throws IOException {
        int i;
        this.action = MagicValues.key(UnlockRecipesAction.class, in.readVarInt());
        this.openCraftingBook = in.readBoolean();
        this.activateCraftingFiltering = in.readBoolean();
        this.openSmeltingBook = in.readBoolean();
        this.activateSmeltingFiltering = in.readBoolean();
        this.openBlastingBook = in.readBoolean();
        this.activateBlastingFiltering = in.readBoolean();
        this.openSmokingBook = in.readBoolean();
        this.activateSmokingFiltering = in.readBoolean();
        if (this.action == UnlockRecipesAction.INIT) {
            this.alreadyKnownRecipes = new String[in.readVarInt()];
            for (i = 0; i < this.alreadyKnownRecipes.length; ++i) {
                this.alreadyKnownRecipes[i] = in.readString();
            }
        } else {
            this.alreadyKnownRecipes = null;
        }
        this.recipes = new String[in.readVarInt()];
        for (i = 0; i < this.recipes.length; ++i) {
            this.recipes[i] = in.readString();
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.action).intValue());
        out.writeBoolean(this.openCraftingBook);
        out.writeBoolean(this.activateCraftingFiltering);
        out.writeBoolean(this.openSmeltingBook);
        out.writeBoolean(this.activateSmeltingFiltering);
        out.writeBoolean(this.openBlastingBook);
        out.writeBoolean(this.activateBlastingFiltering);
        out.writeBoolean(this.openSmokingBook);
        out.writeBoolean(this.activateSmokingFiltering);
        if (this.action == UnlockRecipesAction.INIT) {
            out.writeVarInt(this.alreadyKnownRecipes.length);
            for (String recipeId : this.alreadyKnownRecipes) {
                out.writeString(recipeId);
            }
        }
        out.writeVarInt(this.recipes.length);
        for (String recipeId : this.recipes) {
            out.writeString(recipeId);
        }
    }

    @NonNull
    public UnlockRecipesAction getAction() {
        return this.action;
    }

    @NonNull
    public String[] getRecipes() {
        return this.recipes;
    }

    public boolean isOpenCraftingBook() {
        return this.openCraftingBook;
    }

    public boolean isActivateCraftingFiltering() {
        return this.activateCraftingFiltering;
    }

    public boolean isOpenSmeltingBook() {
        return this.openSmeltingBook;
    }

    public boolean isActivateSmeltingFiltering() {
        return this.activateSmeltingFiltering;
    }

    public boolean isOpenBlastingBook() {
        return this.openBlastingBook;
    }

    public boolean isActivateBlastingFiltering() {
        return this.activateBlastingFiltering;
    }

    public boolean isOpenSmokingBook() {
        return this.openSmokingBook;
    }

    public boolean isActivateSmokingFiltering() {
        return this.activateSmokingFiltering;
    }

    public String[] getAlreadyKnownRecipes() {
        return this.alreadyKnownRecipes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRecipePacket)) {
            return false;
        }
        ClientboundRecipePacket other = (ClientboundRecipePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOpenCraftingBook() != other.isOpenCraftingBook()) {
            return false;
        }
        if (this.isActivateCraftingFiltering() != other.isActivateCraftingFiltering()) {
            return false;
        }
        if (this.isOpenSmeltingBook() != other.isOpenSmeltingBook()) {
            return false;
        }
        if (this.isActivateSmeltingFiltering() != other.isActivateSmeltingFiltering()) {
            return false;
        }
        if (this.isOpenBlastingBook() != other.isOpenBlastingBook()) {
            return false;
        }
        if (this.isActivateBlastingFiltering() != other.isActivateBlastingFiltering()) {
            return false;
        }
        if (this.isOpenSmokingBook() != other.isOpenSmokingBook()) {
            return false;
        }
        if (this.isActivateSmokingFiltering() != other.isActivateSmokingFiltering()) {
            return false;
        }
        UnlockRecipesAction this$action = this.getAction();
        UnlockRecipesAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getRecipes(), other.getRecipes())) {
            return false;
        }
        return Arrays.deepEquals(this.getAlreadyKnownRecipes(), other.getAlreadyKnownRecipes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundRecipePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOpenCraftingBook() ? 79 : 97);
        result = result * 59 + (this.isActivateCraftingFiltering() ? 79 : 97);
        result = result * 59 + (this.isOpenSmeltingBook() ? 79 : 97);
        result = result * 59 + (this.isActivateSmeltingFiltering() ? 79 : 97);
        result = result * 59 + (this.isOpenBlastingBook() ? 79 : 97);
        result = result * 59 + (this.isActivateBlastingFiltering() ? 79 : 97);
        result = result * 59 + (this.isOpenSmokingBook() ? 79 : 97);
        result = result * 59 + (this.isActivateSmokingFiltering() ? 79 : 97);
        UnlockRecipesAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getRecipes());
        result = result * 59 + Arrays.deepHashCode(this.getAlreadyKnownRecipes());
        return result;
    }

    public String toString() {
        return "ClientboundRecipePacket(action=" + (Object)((Object)this.getAction()) + ", recipes=" + Arrays.deepToString(this.getRecipes()) + ", openCraftingBook=" + this.isOpenCraftingBook() + ", activateCraftingFiltering=" + this.isActivateCraftingFiltering() + ", openSmeltingBook=" + this.isOpenSmeltingBook() + ", activateSmeltingFiltering=" + this.isActivateSmeltingFiltering() + ", openBlastingBook=" + this.isOpenBlastingBook() + ", activateBlastingFiltering=" + this.isActivateBlastingFiltering() + ", openSmokingBook=" + this.isOpenSmokingBook() + ", activateSmokingFiltering=" + this.isActivateSmokingFiltering() + ", alreadyKnownRecipes=" + Arrays.deepToString(this.getAlreadyKnownRecipes()) + ")";
    }

    public ClientboundRecipePacket withAction(@NonNull UnlockRecipesAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ClientboundRecipePacket(action, this.recipes, this.openCraftingBook, this.activateCraftingFiltering, this.openSmeltingBook, this.activateSmeltingFiltering, this.openBlastingBook, this.activateBlastingFiltering, this.openSmokingBook, this.activateSmokingFiltering, this.alreadyKnownRecipes);
    }

    public ClientboundRecipePacket withRecipes(@NonNull String[] recipes) {
        if (recipes == null) {
            throw new NullPointerException("recipes is marked non-null but is null");
        }
        return this.recipes == recipes ? this : new ClientboundRecipePacket(this.action, recipes, this.openCraftingBook, this.activateCraftingFiltering, this.openSmeltingBook, this.activateSmeltingFiltering, this.openBlastingBook, this.activateBlastingFiltering, this.openSmokingBook, this.activateSmokingFiltering, this.alreadyKnownRecipes);
    }

    public ClientboundRecipePacket withOpenCraftingBook(boolean openCraftingBook) {
        return this.openCraftingBook == openCraftingBook ? this : new ClientboundRecipePacket(this.action, this.recipes, openCraftingBook, this.activateCraftingFiltering, this.openSmeltingBook, this.activateSmeltingFiltering, this.openBlastingBook, this.activateBlastingFiltering, this.openSmokingBook, this.activateSmokingFiltering, this.alreadyKnownRecipes);
    }

    public ClientboundRecipePacket withActivateCraftingFiltering(boolean activateCraftingFiltering) {
        return this.activateCraftingFiltering == activateCraftingFiltering ? this : new ClientboundRecipePacket(this.action, this.recipes, this.openCraftingBook, activateCraftingFiltering, this.openSmeltingBook, this.activateSmeltingFiltering, this.openBlastingBook, this.activateBlastingFiltering, this.openSmokingBook, this.activateSmokingFiltering, this.alreadyKnownRecipes);
    }

    public ClientboundRecipePacket withOpenSmeltingBook(boolean openSmeltingBook) {
        return this.openSmeltingBook == openSmeltingBook ? this : new ClientboundRecipePacket(this.action, this.recipes, this.openCraftingBook, this.activateCraftingFiltering, openSmeltingBook, this.activateSmeltingFiltering, this.openBlastingBook, this.activateBlastingFiltering, this.openSmokingBook, this.activateSmokingFiltering, this.alreadyKnownRecipes);
    }

    public ClientboundRecipePacket withActivateSmeltingFiltering(boolean activateSmeltingFiltering) {
        return this.activateSmeltingFiltering == activateSmeltingFiltering ? this : new ClientboundRecipePacket(this.action, this.recipes, this.openCraftingBook, this.activateCraftingFiltering, this.openSmeltingBook, activateSmeltingFiltering, this.openBlastingBook, this.activateBlastingFiltering, this.openSmokingBook, this.activateSmokingFiltering, this.alreadyKnownRecipes);
    }

    public ClientboundRecipePacket withOpenBlastingBook(boolean openBlastingBook) {
        return this.openBlastingBook == openBlastingBook ? this : new ClientboundRecipePacket(this.action, this.recipes, this.openCraftingBook, this.activateCraftingFiltering, this.openSmeltingBook, this.activateSmeltingFiltering, openBlastingBook, this.activateBlastingFiltering, this.openSmokingBook, this.activateSmokingFiltering, this.alreadyKnownRecipes);
    }

    public ClientboundRecipePacket withActivateBlastingFiltering(boolean activateBlastingFiltering) {
        return this.activateBlastingFiltering == activateBlastingFiltering ? this : new ClientboundRecipePacket(this.action, this.recipes, this.openCraftingBook, this.activateCraftingFiltering, this.openSmeltingBook, this.activateSmeltingFiltering, this.openBlastingBook, activateBlastingFiltering, this.openSmokingBook, this.activateSmokingFiltering, this.alreadyKnownRecipes);
    }

    public ClientboundRecipePacket withOpenSmokingBook(boolean openSmokingBook) {
        return this.openSmokingBook == openSmokingBook ? this : new ClientboundRecipePacket(this.action, this.recipes, this.openCraftingBook, this.activateCraftingFiltering, this.openSmeltingBook, this.activateSmeltingFiltering, this.openBlastingBook, this.activateBlastingFiltering, openSmokingBook, this.activateSmokingFiltering, this.alreadyKnownRecipes);
    }

    public ClientboundRecipePacket withActivateSmokingFiltering(boolean activateSmokingFiltering) {
        return this.activateSmokingFiltering == activateSmokingFiltering ? this : new ClientboundRecipePacket(this.action, this.recipes, this.openCraftingBook, this.activateCraftingFiltering, this.openSmeltingBook, this.activateSmeltingFiltering, this.openBlastingBook, this.activateBlastingFiltering, this.openSmokingBook, activateSmokingFiltering, this.alreadyKnownRecipes);
    }

    public ClientboundRecipePacket withAlreadyKnownRecipes(String[] alreadyKnownRecipes) {
        return this.alreadyKnownRecipes == alreadyKnownRecipes ? this : new ClientboundRecipePacket(this.action, this.recipes, this.openCraftingBook, this.activateCraftingFiltering, this.openSmeltingBook, this.activateSmeltingFiltering, this.openBlastingBook, this.activateBlastingFiltering, this.openSmokingBook, this.activateSmokingFiltering, alreadyKnownRecipes);
    }

    private ClientboundRecipePacket(@NonNull UnlockRecipesAction action, @NonNull String[] recipes, boolean openCraftingBook, boolean activateCraftingFiltering, boolean openSmeltingBook, boolean activateSmeltingFiltering, boolean openBlastingBook, boolean activateBlastingFiltering, boolean openSmokingBook, boolean activateSmokingFiltering, String[] alreadyKnownRecipes) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (recipes == null) {
            throw new NullPointerException("recipes is marked non-null but is null");
        }
        this.action = action;
        this.recipes = recipes;
        this.openCraftingBook = openCraftingBook;
        this.activateCraftingFiltering = activateCraftingFiltering;
        this.openSmeltingBook = openSmeltingBook;
        this.activateSmeltingFiltering = activateSmeltingFiltering;
        this.openBlastingBook = openBlastingBook;
        this.activateBlastingFiltering = activateBlastingFiltering;
        this.openSmokingBook = openSmokingBook;
        this.activateSmokingFiltering = activateSmokingFiltering;
        this.alreadyKnownRecipes = alreadyKnownRecipes;
    }
}

