/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.entity.metadata;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.MetadataType;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.FloatEntityMetadata;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import java.io.IOException;

public class FloatMetadataType
extends MetadataType<Float> {
    private final FloatReader primitiveReader;
    private final FloatWriter primitiveWriter;
    private final FloatEntityMetadataFactory primitiveFactory;

    protected FloatMetadataType(FloatReader reader, FloatWriter writer, FloatEntityMetadataFactory metadataFactory) {
        super(reader, writer, metadataFactory);
        this.primitiveReader = reader;
        this.primitiveWriter = writer;
        this.primitiveFactory = metadataFactory;
    }

    @Override
    public EntityMetadata<Float, FloatMetadataType> readMetadata(NetInput input, int id) throws IOException {
        return this.primitiveFactory.createPrimitive(id, this, this.primitiveReader.readPrimitive(input));
    }

    public void writeMetadataPrimitive(NetOutput output, float value) throws IOException {
        this.primitiveWriter.writePrimitive(output, value);
    }

    @FunctionalInterface
    public static interface FloatEntityMetadataFactory
    extends MetadataType.EntityMetadataFactory<Float> {
        public FloatEntityMetadata createPrimitive(int var1, FloatMetadataType var2, float var3);

        @Override
        @Deprecated
        default public EntityMetadata<Float, FloatMetadataType> create(int id, MetadataType<Float> type, Float value) {
            throw new UnsupportedOperationException("Unsupported read method! Use primitive createPrimitive!");
        }
    }

    @FunctionalInterface
    public static interface FloatWriter
    extends MetadataType.Writer<Float> {
        public void writePrimitive(NetOutput var1, float var2) throws IOException;

        @Override
        @Deprecated
        default public void write(NetOutput output, Float value) throws IOException {
            this.writePrimitive(output, value.floatValue());
        }
    }

    @FunctionalInterface
    public static interface FloatReader
    extends MetadataType.Reader<Float> {
        public float readPrimitive(NetInput var1) throws IOException;

        @Override
        @Deprecated
        default public Float read(NetInput input) throws IOException {
            return Float.valueOf(this.readPrimitive(input));
        }
    }
}

