/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.entity.metadata;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.MetadataType;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import java.io.IOException;

public class ByteMetadataType
extends MetadataType<Byte> {
    private final ByteReader primitiveReader;
    private final ByteWriter primitiveWriter;
    private final ByteEntityMetadataFactory primitiveFactory;

    protected ByteMetadataType(ByteReader reader, ByteWriter writer, ByteEntityMetadataFactory metadataFactory) {
        super(reader, writer, metadataFactory);
        this.primitiveReader = reader;
        this.primitiveWriter = writer;
        this.primitiveFactory = metadataFactory;
    }

    @Override
    public EntityMetadata<Byte, ByteMetadataType> readMetadata(NetInput input, int id) throws IOException {
        return this.primitiveFactory.createPrimitive(id, this, this.primitiveReader.readPrimitive(input));
    }

    public void writeMetadataPrimitive(NetOutput output, byte value) throws IOException {
        this.primitiveWriter.writePrimitive(output, value);
    }

    @FunctionalInterface
    public static interface ByteEntityMetadataFactory
    extends MetadataType.EntityMetadataFactory<Byte> {
        public ByteEntityMetadata createPrimitive(int var1, ByteMetadataType var2, byte var3);

        @Override
        @Deprecated
        default public EntityMetadata<Byte, ByteMetadataType> create(int id, MetadataType<Byte> type, Byte value) {
            throw new UnsupportedOperationException("Unsupported read method! Use primitive createPrimitive!");
        }
    }

    @FunctionalInterface
    public static interface ByteWriter
    extends MetadataType.Writer<Byte> {
        public void writePrimitive(NetOutput var1, byte var2) throws IOException;

        @Override
        @Deprecated
        default public void write(NetOutput output, Byte value) throws IOException {
            this.writePrimitive(output, value);
        }
    }

    @FunctionalInterface
    public static interface ByteReader
    extends MetadataType.Reader<Byte> {
        public byte readPrimitive(NetInput var1) throws IOException;

        @Override
        @Deprecated
        default public Byte read(NetInput input) throws IOException {
            return this.readPrimitive(input);
        }
    }
}

