/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.player;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.github.steveice10.mc.protocol.data.game.entity.player.InteractAction;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerboundInteractPacket
implements Packet {
    private final int entityId;
    @NonNull
    private final InteractAction action;
    private final float targetX;
    private final float targetY;
    private final float targetZ;
    private final Hand hand;
    private final boolean isSneaking;

    public ServerboundInteractPacket(int entityId, InteractAction action, boolean isSneaking) {
        this(entityId, action, Hand.MAIN_HAND, isSneaking);
    }

    public ServerboundInteractPacket(int entityId, InteractAction action, @NonNull Hand hand, boolean isSneaking) {
        this(entityId, action, 0.0f, 0.0f, 0.0f, hand, isSneaking);
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
    }

    public ServerboundInteractPacket(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.action = MagicValues.key(InteractAction.class, in.readVarInt());
        if (this.action == InteractAction.INTERACT_AT) {
            this.targetX = in.readFloat();
            this.targetY = in.readFloat();
            this.targetZ = in.readFloat();
        } else {
            this.targetX = 0.0f;
            this.targetY = 0.0f;
            this.targetZ = 0.0f;
        }
        this.hand = this.action == InteractAction.INTERACT || this.action == InteractAction.INTERACT_AT ? MagicValues.key(Hand.class, in.readVarInt()) : null;
        this.isSneaking = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.action).intValue());
        if (this.action == InteractAction.INTERACT_AT) {
            out.writeFloat(this.targetX);
            out.writeFloat(this.targetY);
            out.writeFloat(this.targetZ);
        }
        if (this.action == InteractAction.INTERACT || this.action == InteractAction.INTERACT_AT) {
            out.writeVarInt(MagicValues.value(Integer.class, (Object)this.hand).intValue());
        }
        out.writeBoolean(this.isSneaking);
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public InteractAction getAction() {
        return this.action;
    }

    public float getTargetX() {
        return this.targetX;
    }

    public float getTargetY() {
        return this.targetY;
    }

    public float getTargetZ() {
        return this.targetZ;
    }

    public Hand getHand() {
        return this.hand;
    }

    public boolean isSneaking() {
        return this.isSneaking;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundInteractPacket)) {
            return false;
        }
        ServerboundInteractPacket other = (ServerboundInteractPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (Float.compare(this.getTargetX(), other.getTargetX()) != 0) {
            return false;
        }
        if (Float.compare(this.getTargetY(), other.getTargetY()) != 0) {
            return false;
        }
        if (Float.compare(this.getTargetZ(), other.getTargetZ()) != 0) {
            return false;
        }
        if (this.isSneaking() != other.isSneaking()) {
            return false;
        }
        InteractAction this$action = this.getAction();
        InteractAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        Hand this$hand = this.getHand();
        Hand other$hand = other.getHand();
        return !(this$hand == null ? other$hand != null : !((Object)((Object)this$hand)).equals((Object)other$hand));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundInteractPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + Float.floatToIntBits(this.getTargetX());
        result = result * 59 + Float.floatToIntBits(this.getTargetY());
        result = result * 59 + Float.floatToIntBits(this.getTargetZ());
        result = result * 59 + (this.isSneaking() ? 79 : 97);
        InteractAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        Hand $hand = this.getHand();
        result = result * 59 + ($hand == null ? 43 : ((Object)((Object)$hand)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundInteractPacket(entityId=" + this.getEntityId() + ", action=" + (Object)((Object)this.getAction()) + ", targetX=" + this.getTargetX() + ", targetY=" + this.getTargetY() + ", targetZ=" + this.getTargetZ() + ", hand=" + (Object)((Object)this.getHand()) + ", isSneaking=" + this.isSneaking() + ")";
    }

    public ServerboundInteractPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerboundInteractPacket(entityId, this.action, this.targetX, this.targetY, this.targetZ, this.hand, this.isSneaking);
    }

    public ServerboundInteractPacket withAction(@NonNull InteractAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ServerboundInteractPacket(this.entityId, action, this.targetX, this.targetY, this.targetZ, this.hand, this.isSneaking);
    }

    public ServerboundInteractPacket withTargetX(float targetX) {
        return this.targetX == targetX ? this : new ServerboundInteractPacket(this.entityId, this.action, targetX, this.targetY, this.targetZ, this.hand, this.isSneaking);
    }

    public ServerboundInteractPacket withTargetY(float targetY) {
        return this.targetY == targetY ? this : new ServerboundInteractPacket(this.entityId, this.action, this.targetX, targetY, this.targetZ, this.hand, this.isSneaking);
    }

    public ServerboundInteractPacket withTargetZ(float targetZ) {
        return this.targetZ == targetZ ? this : new ServerboundInteractPacket(this.entityId, this.action, this.targetX, this.targetY, targetZ, this.hand, this.isSneaking);
    }

    public ServerboundInteractPacket withHand(Hand hand) {
        return this.hand == hand ? this : new ServerboundInteractPacket(this.entityId, this.action, this.targetX, this.targetY, this.targetZ, hand, this.isSneaking);
    }

    public ServerboundInteractPacket withSneaking(boolean isSneaking) {
        return this.isSneaking == isSneaking ? this : new ServerboundInteractPacket(this.entityId, this.action, this.targetX, this.targetY, this.targetZ, this.hand, isSneaking);
    }

    public ServerboundInteractPacket(int entityId, @NonNull InteractAction action, float targetX, float targetY, float targetZ, Hand hand, boolean isSneaking) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.entityId = entityId;
        this.action = action;
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
        this.hand = hand;
        this.isSneaking = isSneaking;
    }
}

