/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.inventory.ClickItemAction;
import com.github.steveice10.mc.protocol.data.game.inventory.ContainerAction;
import com.github.steveice10.mc.protocol.data.game.inventory.ContainerActionType;
import com.github.steveice10.mc.protocol.data.game.inventory.CreativeGrabAction;
import com.github.steveice10.mc.protocol.data.game.inventory.DropItemAction;
import com.github.steveice10.mc.protocol.data.game.inventory.FillStackAction;
import com.github.steveice10.mc.protocol.data.game.inventory.MoveToHotbarAction;
import com.github.steveice10.mc.protocol.data.game.inventory.ShiftClickItemAction;
import com.github.steveice10.mc.protocol.data.game.inventory.SpreadItemAction;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import io.netty.util.collection.IntObjectHashMap;
import java.io.IOException;
import java.util.Map;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class ServerboundContainerClickPacket
implements Packet {
    public static final int CLICK_OUTSIDE_NOT_HOLDING_SLOT = -999;
    private final int containerId;
    private final int stateId;
    private final int slot;
    private final ContainerActionType action;
    private final ContainerAction param;
    private final ItemStack carriedItem;
    @NonNull
    private final Map<Integer, ItemStack> changedSlots;

    public ServerboundContainerClickPacket(int containerId, int stateId, int slot, ContainerActionType action, ContainerAction param, ItemStack carriedItem, @NotNull Map<Integer, ItemStack> changedSlots) {
        if ((param == DropItemAction.LEFT_CLICK_OUTSIDE_NOT_HOLDING || param == DropItemAction.RIGHT_CLICK_OUTSIDE_NOT_HOLDING) && slot != 999) {
            throw new IllegalArgumentException("Slot must be -999 with param LEFT_CLICK_OUTSIDE_NOT_HOLDING or RIGHT_CLICK_OUTSIDE_NOT_HOLDING");
        }
        this.containerId = containerId;
        this.stateId = stateId;
        this.slot = slot;
        this.action = action;
        this.param = param;
        this.carriedItem = carriedItem;
        this.changedSlots = changedSlots;
    }

    public ServerboundContainerClickPacket(NetInput in) throws IOException {
        this.containerId = in.readByte();
        this.stateId = in.readVarInt();
        this.slot = in.readShort();
        byte param = in.readByte();
        this.action = MagicValues.key(ContainerActionType.class, in.readByte());
        if (this.action == ContainerActionType.CLICK_ITEM) {
            this.param = MagicValues.key(ClickItemAction.class, param);
        } else if (this.action == ContainerActionType.SHIFT_CLICK_ITEM) {
            this.param = MagicValues.key(ShiftClickItemAction.class, param);
        } else if (this.action == ContainerActionType.MOVE_TO_HOTBAR_SLOT) {
            this.param = MagicValues.key(MoveToHotbarAction.class, param);
        } else if (this.action == ContainerActionType.CREATIVE_GRAB_MAX_STACK) {
            this.param = MagicValues.key(CreativeGrabAction.class, param);
        } else if (this.action == ContainerActionType.DROP_ITEM) {
            this.param = MagicValues.key(DropItemAction.class, param + (this.slot != -999 ? 2 : 0));
        } else if (this.action == ContainerActionType.SPREAD_ITEM) {
            this.param = MagicValues.key(SpreadItemAction.class, param);
        } else if (this.action == ContainerActionType.FILL_STACK) {
            this.param = MagicValues.key(FillStackAction.class, param);
        } else {
            throw new IllegalStateException();
        }
        int changedItemsSize = in.readVarInt();
        this.changedSlots = new IntObjectHashMap(changedItemsSize);
        for (int i = 0; i < changedItemsSize; ++i) {
            short key = in.readShort();
            ItemStack value = ItemStack.read(in);
            this.changedSlots.put(Integer.valueOf(key), value);
        }
        this.carriedItem = ItemStack.read(in);
    }

    public void write(NetOutput out) throws IOException {
        out.writeByte(this.containerId);
        out.writeVarInt(this.stateId);
        out.writeShort(this.slot);
        int param = MagicValues.value(Integer.class, this.param);
        if (this.action == ContainerActionType.DROP_ITEM) {
            param %= 2;
        }
        out.writeByte(param);
        out.writeByte(MagicValues.value(Integer.class, (Object)this.action).intValue());
        out.writeVarInt(this.changedSlots.size());
        for (Map.Entry<Integer, ItemStack> pair : this.changedSlots.entrySet()) {
            out.writeShort(pair.getKey().intValue());
            ItemStack.write(out, pair.getValue());
        }
        ItemStack.write(out, this.carriedItem);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getStateId() {
        return this.stateId;
    }

    public int getSlot() {
        return this.slot;
    }

    public ContainerActionType getAction() {
        return this.action;
    }

    public ContainerAction getParam() {
        return this.param;
    }

    public ItemStack getCarriedItem() {
        return this.carriedItem;
    }

    @NonNull
    public Map<Integer, ItemStack> getChangedSlots() {
        return this.changedSlots;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundContainerClickPacket)) {
            return false;
        }
        ServerboundContainerClickPacket other = (ServerboundContainerClickPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        if (this.getStateId() != other.getStateId()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        ContainerActionType this$action = this.getAction();
        ContainerActionType other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        ContainerAction this$param = this.getParam();
        ContainerAction other$param = other.getParam();
        if (this$param == null ? other$param != null : !this$param.equals(other$param)) {
            return false;
        }
        ItemStack this$carriedItem = this.getCarriedItem();
        ItemStack other$carriedItem = other.getCarriedItem();
        if (this$carriedItem == null ? other$carriedItem != null : !((Object)this$carriedItem).equals(other$carriedItem)) {
            return false;
        }
        Map<Integer, ItemStack> this$changedSlots = this.getChangedSlots();
        Map<Integer, ItemStack> other$changedSlots = other.getChangedSlots();
        return !(this$changedSlots == null ? other$changedSlots != null : !((Object)this$changedSlots).equals(other$changedSlots));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundContainerClickPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        result = result * 59 + this.getStateId();
        result = result * 59 + this.getSlot();
        ContainerActionType $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        ContainerAction $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : $param.hashCode());
        ItemStack $carriedItem = this.getCarriedItem();
        result = result * 59 + ($carriedItem == null ? 43 : ((Object)$carriedItem).hashCode());
        Map<Integer, ItemStack> $changedSlots = this.getChangedSlots();
        result = result * 59 + ($changedSlots == null ? 43 : ((Object)$changedSlots).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundContainerClickPacket(containerId=" + this.getContainerId() + ", stateId=" + this.getStateId() + ", slot=" + this.getSlot() + ", action=" + (Object)((Object)this.getAction()) + ", param=" + this.getParam() + ", carriedItem=" + this.getCarriedItem() + ", changedSlots=" + this.getChangedSlots() + ")";
    }

    public ServerboundContainerClickPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ServerboundContainerClickPacket(containerId, this.stateId, this.slot, this.action, this.param, this.carriedItem, this.changedSlots);
    }

    public ServerboundContainerClickPacket withStateId(int stateId) {
        return this.stateId == stateId ? this : new ServerboundContainerClickPacket(this.containerId, stateId, this.slot, this.action, this.param, this.carriedItem, this.changedSlots);
    }

    public ServerboundContainerClickPacket withSlot(int slot) {
        return this.slot == slot ? this : new ServerboundContainerClickPacket(this.containerId, this.stateId, slot, this.action, this.param, this.carriedItem, this.changedSlots);
    }

    public ServerboundContainerClickPacket withAction(ContainerActionType action) {
        return this.action == action ? this : new ServerboundContainerClickPacket(this.containerId, this.stateId, this.slot, action, this.param, this.carriedItem, this.changedSlots);
    }

    public ServerboundContainerClickPacket withParam(ContainerAction param) {
        return this.param == param ? this : new ServerboundContainerClickPacket(this.containerId, this.stateId, this.slot, this.action, param, this.carriedItem, this.changedSlots);
    }

    public ServerboundContainerClickPacket withCarriedItem(ItemStack carriedItem) {
        return this.carriedItem == carriedItem ? this : new ServerboundContainerClickPacket(this.containerId, this.stateId, this.slot, this.action, this.param, carriedItem, this.changedSlots);
    }

    public ServerboundContainerClickPacket withChangedSlots(@NonNull Map<Integer, ItemStack> changedSlots) {
        if (changedSlots == null) {
            throw new NullPointerException("changedSlots is marked non-null but is null");
        }
        return this.changedSlots == changedSlots ? this : new ServerboundContainerClickPacket(this.containerId, this.stateId, this.slot, this.action, this.param, this.carriedItem, changedSlots);
    }
}

