/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.mc.protocol.data.game.Identifier;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.Attribute;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.AttributeModifier;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.AttributeType;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.ModifierOperation;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class ClientboundUpdateAttributesPacket
implements Packet {
    private final int entityId;
    @NonNull
    private final List<Attribute> attributes;

    public ClientboundUpdateAttributesPacket(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.attributes = new ArrayList<Attribute>();
        int length = in.readVarInt();
        for (int index = 0; index < length; ++index) {
            String key = in.readString();
            double value = in.readDouble();
            ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
            int len = in.readVarInt();
            for (int ind = 0; ind < len; ++ind) {
                modifiers.add(new AttributeModifier(in.readUUID(), in.readDouble(), ModifierOperation.read(in)));
            }
            AttributeType type = AttributeType.Builtin.BUILTIN.computeIfAbsent(Identifier.formalize(key), AttributeType.Custom::new);
            this.attributes.add(new Attribute(type, value, modifiers));
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeVarInt(this.attributes.size());
        for (Attribute attribute : this.attributes) {
            out.writeString(attribute.getType().getIdentifier());
            out.writeDouble(attribute.getValue());
            out.writeVarInt(attribute.getModifiers().size());
            for (AttributeModifier modifier : attribute.getModifiers()) {
                out.writeUUID(modifier.getUuid());
                out.writeDouble(modifier.getAmount());
                out.writeByte(modifier.getOperation().ordinal());
            }
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateAttributesPacket)) {
            return false;
        }
        ClientboundUpdateAttributesPacket other = (ClientboundUpdateAttributesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        List<Attribute> this$attributes = this.getAttributes();
        List<Attribute> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundUpdateAttributesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        List<Attribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundUpdateAttributesPacket(entityId=" + this.getEntityId() + ", attributes=" + this.getAttributes() + ")";
    }

    public ClientboundUpdateAttributesPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundUpdateAttributesPacket(entityId, this.attributes);
    }

    public ClientboundUpdateAttributesPacket withAttributes(@NonNull List<Attribute> attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        return this.attributes == attributes ? this : new ClientboundUpdateAttributesPacket(this.entityId, attributes);
    }

    public ClientboundUpdateAttributesPacket(int entityId, @NonNull List<Attribute> attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        this.entityId = entityId;
        this.attributes = attributes;
    }
}

