/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.level.sound.SoundCategory;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundSoundEntityPacket
implements Packet {
    private final int soundId;
    @NonNull
    private final SoundCategory soundCategory;
    private final int entityId;
    private final float volume;
    private final float pitch;

    public ClientboundSoundEntityPacket(NetInput in) throws IOException {
        this.soundId = in.readVarInt();
        this.soundCategory = MagicValues.key(SoundCategory.class, in.readVarInt());
        this.entityId = in.readVarInt();
        this.volume = in.readFloat();
        this.pitch = in.readFloat();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.soundId);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.soundCategory).intValue());
        out.writeVarInt(this.entityId);
        out.writeFloat(this.volume);
        out.writeFloat(this.pitch);
    }

    public int getSoundId() {
        return this.soundId;
    }

    @NonNull
    public SoundCategory getSoundCategory() {
        return this.soundCategory;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSoundEntityPacket)) {
            return false;
        }
        ClientboundSoundEntityPacket other = (ClientboundSoundEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSoundId() != other.getSoundId()) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (Float.compare(this.getVolume(), other.getVolume()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        SoundCategory this$soundCategory = this.getSoundCategory();
        SoundCategory other$soundCategory = other.getSoundCategory();
        return !(this$soundCategory == null ? other$soundCategory != null : !((Object)((Object)this$soundCategory)).equals((Object)other$soundCategory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSoundEntityPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSoundId();
        result = result * 59 + this.getEntityId();
        result = result * 59 + Float.floatToIntBits(this.getVolume());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        SoundCategory $soundCategory = this.getSoundCategory();
        result = result * 59 + ($soundCategory == null ? 43 : ((Object)((Object)$soundCategory)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundSoundEntityPacket(soundId=" + this.getSoundId() + ", soundCategory=" + (Object)((Object)this.getSoundCategory()) + ", entityId=" + this.getEntityId() + ", volume=" + this.getVolume() + ", pitch=" + this.getPitch() + ")";
    }

    public ClientboundSoundEntityPacket withSoundId(int soundId) {
        return this.soundId == soundId ? this : new ClientboundSoundEntityPacket(soundId, this.soundCategory, this.entityId, this.volume, this.pitch);
    }

    public ClientboundSoundEntityPacket withSoundCategory(@NonNull SoundCategory soundCategory) {
        if (soundCategory == null) {
            throw new NullPointerException("soundCategory is marked non-null but is null");
        }
        return this.soundCategory == soundCategory ? this : new ClientboundSoundEntityPacket(this.soundId, soundCategory, this.entityId, this.volume, this.pitch);
    }

    public ClientboundSoundEntityPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundSoundEntityPacket(this.soundId, this.soundCategory, entityId, this.volume, this.pitch);
    }

    public ClientboundSoundEntityPacket withVolume(float volume) {
        return this.volume == volume ? this : new ClientboundSoundEntityPacket(this.soundId, this.soundCategory, this.entityId, volume, this.pitch);
    }

    public ClientboundSoundEntityPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ClientboundSoundEntityPacket(this.soundId, this.soundCategory, this.entityId, this.volume, pitch);
    }

    public ClientboundSoundEntityPacket(int soundId, @NonNull SoundCategory soundCategory, int entityId, float volume, float pitch) {
        if (soundCategory == null) {
            throw new NullPointerException("soundCategory is marked non-null but is null");
        }
        this.soundId = soundId;
        this.soundCategory = soundCategory;
        this.entityId = entityId;
        this.volume = volume;
        this.pitch = pitch;
    }
}

