/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.NBT;
import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundRespawnPacket
implements Packet {
    @NonNull
    private final CompoundTag dimension;
    @NonNull
    private final String worldName;
    private final long hashedSeed;
    @NonNull
    private final GameMode gamemode;
    @NonNull
    private final GameMode previousGamemode;
    private final boolean debug;
    private final boolean flat;
    private final boolean copyMetadata;

    public ClientboundRespawnPacket(NetInput in) throws IOException {
        this.dimension = NBT.read(in);
        this.worldName = in.readString();
        this.hashedSeed = in.readLong();
        this.gamemode = MagicValues.key(GameMode.class, in.readUnsignedByte());
        this.previousGamemode = MagicValues.key(GameMode.class, in.readUnsignedByte());
        this.debug = in.readBoolean();
        this.flat = in.readBoolean();
        this.copyMetadata = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        NBT.write(out, this.dimension);
        out.writeString(this.worldName);
        out.writeLong(this.hashedSeed);
        out.writeByte(MagicValues.value(Integer.class, this.gamemode).intValue());
        out.writeByte(MagicValues.value(Integer.class, this.previousGamemode).intValue());
        out.writeBoolean(this.debug);
        out.writeBoolean(this.flat);
        out.writeBoolean(this.copyMetadata);
    }

    @NonNull
    public CompoundTag getDimension() {
        return this.dimension;
    }

    @NonNull
    public String getWorldName() {
        return this.worldName;
    }

    public long getHashedSeed() {
        return this.hashedSeed;
    }

    @NonNull
    public GameMode getGamemode() {
        return this.gamemode;
    }

    @NonNull
    public GameMode getPreviousGamemode() {
        return this.previousGamemode;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public boolean isCopyMetadata() {
        return this.copyMetadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRespawnPacket)) {
            return false;
        }
        ClientboundRespawnPacket other = (ClientboundRespawnPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHashedSeed() != other.getHashedSeed()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isFlat() != other.isFlat()) {
            return false;
        }
        if (this.isCopyMetadata() != other.isCopyMetadata()) {
            return false;
        }
        CompoundTag this$dimension = this.getDimension();
        CompoundTag other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$worldName = this.getWorldName();
        String other$worldName = other.getWorldName();
        if (this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName)) {
            return false;
        }
        GameMode this$gamemode = this.getGamemode();
        GameMode other$gamemode = other.getGamemode();
        if (this$gamemode == null ? other$gamemode != null : !this$gamemode.equals(other$gamemode)) {
            return false;
        }
        GameMode this$previousGamemode = this.getPreviousGamemode();
        GameMode other$previousGamemode = other.getPreviousGamemode();
        return !(this$previousGamemode == null ? other$previousGamemode != null : !this$previousGamemode.equals(other$previousGamemode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundRespawnPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $hashedSeed = this.getHashedSeed();
        result = result * 59 + (int)($hashedSeed >>> 32 ^ $hashedSeed);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isFlat() ? 79 : 97);
        result = result * 59 + (this.isCopyMetadata() ? 79 : 97);
        CompoundTag $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $worldName = this.getWorldName();
        result = result * 59 + ($worldName == null ? 43 : $worldName.hashCode());
        GameMode $gamemode = this.getGamemode();
        result = result * 59 + ($gamemode == null ? 43 : $gamemode.hashCode());
        GameMode $previousGamemode = this.getPreviousGamemode();
        result = result * 59 + ($previousGamemode == null ? 43 : $previousGamemode.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundRespawnPacket(dimension=" + this.getDimension() + ", worldName=" + this.getWorldName() + ", hashedSeed=" + this.getHashedSeed() + ", gamemode=" + this.getGamemode() + ", previousGamemode=" + this.getPreviousGamemode() + ", debug=" + this.isDebug() + ", flat=" + this.isFlat() + ", copyMetadata=" + this.isCopyMetadata() + ")";
    }

    public ClientboundRespawnPacket withDimension(@NonNull CompoundTag dimension) {
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        return this.dimension == dimension ? this : new ClientboundRespawnPacket(dimension, this.worldName, this.hashedSeed, this.gamemode, this.previousGamemode, this.debug, this.flat, this.copyMetadata);
    }

    public ClientboundRespawnPacket withWorldName(@NonNull String worldName) {
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        return this.worldName == worldName ? this : new ClientboundRespawnPacket(this.dimension, worldName, this.hashedSeed, this.gamemode, this.previousGamemode, this.debug, this.flat, this.copyMetadata);
    }

    public ClientboundRespawnPacket withHashedSeed(long hashedSeed) {
        return this.hashedSeed == hashedSeed ? this : new ClientboundRespawnPacket(this.dimension, this.worldName, hashedSeed, this.gamemode, this.previousGamemode, this.debug, this.flat, this.copyMetadata);
    }

    public ClientboundRespawnPacket withGamemode(@NonNull GameMode gamemode) {
        if (gamemode == null) {
            throw new NullPointerException("gamemode is marked non-null but is null");
        }
        return this.gamemode == gamemode ? this : new ClientboundRespawnPacket(this.dimension, this.worldName, this.hashedSeed, gamemode, this.previousGamemode, this.debug, this.flat, this.copyMetadata);
    }

    public ClientboundRespawnPacket withPreviousGamemode(@NonNull GameMode previousGamemode) {
        if (previousGamemode == null) {
            throw new NullPointerException("previousGamemode is marked non-null but is null");
        }
        return this.previousGamemode == previousGamemode ? this : new ClientboundRespawnPacket(this.dimension, this.worldName, this.hashedSeed, this.gamemode, previousGamemode, this.debug, this.flat, this.copyMetadata);
    }

    public ClientboundRespawnPacket withDebug(boolean debug) {
        return this.debug == debug ? this : new ClientboundRespawnPacket(this.dimension, this.worldName, this.hashedSeed, this.gamemode, this.previousGamemode, debug, this.flat, this.copyMetadata);
    }

    public ClientboundRespawnPacket withFlat(boolean flat) {
        return this.flat == flat ? this : new ClientboundRespawnPacket(this.dimension, this.worldName, this.hashedSeed, this.gamemode, this.previousGamemode, this.debug, flat, this.copyMetadata);
    }

    public ClientboundRespawnPacket withCopyMetadata(boolean copyMetadata) {
        return this.copyMetadata == copyMetadata ? this : new ClientboundRespawnPacket(this.dimension, this.worldName, this.hashedSeed, this.gamemode, this.previousGamemode, this.debug, this.flat, copyMetadata);
    }

    public ClientboundRespawnPacket(@NonNull CompoundTag dimension, @NonNull String worldName, long hashedSeed, @NonNull GameMode gamemode, @NonNull GameMode previousGamemode, boolean debug, boolean flat, boolean copyMetadata) {
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        if (gamemode == null) {
            throw new NullPointerException("gamemode is marked non-null but is null");
        }
        if (previousGamemode == null) {
            throw new NullPointerException("previousGamemode is marked non-null but is null");
        }
        this.dimension = dimension;
        this.worldName = worldName;
        this.hashedSeed = hashedSeed;
        this.gamemode = gamemode;
        this.previousGamemode = previousGamemode;
        this.debug = debug;
        this.flat = flat;
        this.copyMetadata = copyMetadata;
    }
}

