/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.status.client;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class StatusPingPacket
implements Packet {
    private long pingTime;

    public void read(NetInput in) throws IOException {
        this.pingTime = in.readLong();
    }

    public void write(NetOutput out) throws IOException {
        out.writeLong(this.pingTime);
    }

    public boolean isPriority() {
        return false;
    }

    public long getPingTime() {
        return this.pingTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatusPingPacket)) {
            return false;
        }
        StatusPingPacket other = (StatusPingPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getPingTime() == other.getPingTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatusPingPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pingTime = this.getPingTime();
        result = result * 59 + (int)($pingTime >>> 32 ^ $pingTime);
        return result;
    }

    public String toString() {
        return "StatusPingPacket(pingTime=" + this.getPingTime() + ")";
    }

    public StatusPingPacket withPingTime(long pingTime) {
        return this.pingTime == pingTime ? this : new StatusPingPacket(pingTime);
    }

    private StatusPingPacket() {
    }

    public StatusPingPacket(long pingTime) {
        this.pingTime = pingTime;
    }
}

