/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.login.server;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class LoginSuccessPacket
implements Packet {
    @NonNull
    private GameProfile profile;

    public void read(NetInput in) throws IOException {
        this.profile = new GameProfile(in.readUUID(), in.readString());
    }

    public void write(NetOutput out) throws IOException {
        out.writeUUID(this.profile.getId());
        out.writeString(this.profile.getName());
    }

    public boolean isPriority() {
        return true;
    }

    @NonNull
    public GameProfile getProfile() {
        return this.profile;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginSuccessPacket)) {
            return false;
        }
        LoginSuccessPacket other = (LoginSuccessPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GameProfile this$profile = this.getProfile();
        GameProfile other$profile = other.getProfile();
        return !(this$profile == null ? other$profile != null : !this$profile.equals(other$profile));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginSuccessPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GameProfile $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        return result;
    }

    public String toString() {
        return "LoginSuccessPacket(profile=" + this.getProfile() + ")";
    }

    public LoginSuccessPacket withProfile(@NonNull GameProfile profile) {
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        return this.profile == profile ? this : new LoginSuccessPacket(profile);
    }

    private LoginSuccessPacket() {
    }

    public LoginSuccessPacket(@NonNull GameProfile profile) {
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        this.profile = profile;
    }
}

