/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.login.server;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class LoginPluginRequestPacket
implements Packet {
    private int messageId;
    @NonNull
    private String channel;
    @NonNull
    private byte[] data;

    public void read(NetInput in) throws IOException {
        this.messageId = in.readVarInt();
        this.channel = in.readString();
        this.data = in.readBytes(in.available());
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.messageId);
        out.writeString(this.channel);
        out.writeBytes(this.data);
    }

    public boolean isPriority() {
        return false;
    }

    public int getMessageId() {
        return this.messageId;
    }

    @NonNull
    public String getChannel() {
        return this.channel;
    }

    @NonNull
    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginPluginRequestPacket)) {
            return false;
        }
        LoginPluginRequestPacket other = (LoginPluginRequestPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMessageId() != other.getMessageId()) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginPluginRequestPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMessageId();
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }

    public String toString() {
        return "LoginPluginRequestPacket(messageId=" + this.getMessageId() + ", channel=" + this.getChannel() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    public LoginPluginRequestPacket withMessageId(int messageId) {
        return this.messageId == messageId ? this : new LoginPluginRequestPacket(messageId, this.channel, this.data);
    }

    public LoginPluginRequestPacket withChannel(@NonNull String channel) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        return this.channel == channel ? this : new LoginPluginRequestPacket(this.messageId, channel, this.data);
    }

    public LoginPluginRequestPacket withData(@NonNull byte[] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return this.data == data ? this : new LoginPluginRequestPacket(this.messageId, this.channel, data);
    }

    private LoginPluginRequestPacket() {
    }

    public LoginPluginRequestPacket(int messageId, @NonNull String channel, @NonNull byte[] data) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.messageId = messageId;
        this.channel = channel;
        this.data = data;
    }
}

