/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.login.server;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import lombok.NonNull;

public class EncryptionRequestPacket
implements Packet {
    @NonNull
    private String serverId;
    @NonNull
    private PublicKey publicKey;
    @NonNull
    private byte[] verifyToken;

    public void read(NetInput in) throws IOException {
        this.serverId = in.readString();
        byte[] publicKey = in.readBytes(in.readVarInt());
        this.verifyToken = in.readBytes(in.readVarInt());
        try {
            this.publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKey));
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Could not decode public key.", e);
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeString(this.serverId);
        byte[] encoded = this.publicKey.getEncoded();
        out.writeVarInt(encoded.length);
        out.writeBytes(encoded);
        out.writeVarInt(this.verifyToken.length);
        out.writeBytes(this.verifyToken);
    }

    public boolean isPriority() {
        return true;
    }

    @NonNull
    public String getServerId() {
        return this.serverId;
    }

    @NonNull
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @NonNull
    public byte[] getVerifyToken() {
        return this.verifyToken;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptionRequestPacket)) {
            return false;
        }
        EncryptionRequestPacket other = (EncryptionRequestPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverId = this.getServerId();
        String other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId)) {
            return false;
        }
        PublicKey this$publicKey = this.getPublicKey();
        PublicKey other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        return Arrays.equals(this.getVerifyToken(), other.getVerifyToken());
    }

    protected boolean canEqual(Object other) {
        return other instanceof EncryptionRequestPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 43 : $serverId.hashCode());
        PublicKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        result = result * 59 + Arrays.hashCode(this.getVerifyToken());
        return result;
    }

    public String toString() {
        return "EncryptionRequestPacket(serverId=" + this.getServerId() + ", publicKey=" + this.getPublicKey() + ", verifyToken=" + Arrays.toString(this.getVerifyToken()) + ")";
    }

    public EncryptionRequestPacket withServerId(@NonNull String serverId) {
        if (serverId == null) {
            throw new NullPointerException("serverId is marked non-null but is null");
        }
        return this.serverId == serverId ? this : new EncryptionRequestPacket(serverId, this.publicKey, this.verifyToken);
    }

    public EncryptionRequestPacket withPublicKey(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return this.publicKey == publicKey ? this : new EncryptionRequestPacket(this.serverId, publicKey, this.verifyToken);
    }

    public EncryptionRequestPacket withVerifyToken(@NonNull byte[] verifyToken) {
        if (verifyToken == null) {
            throw new NullPointerException("verifyToken is marked non-null but is null");
        }
        return this.verifyToken == verifyToken ? this : new EncryptionRequestPacket(this.serverId, this.publicKey, verifyToken);
    }

    private EncryptionRequestPacket() {
    }

    public EncryptionRequestPacket(@NonNull String serverId, @NonNull PublicKey publicKey, @NonNull byte[] verifyToken) {
        if (serverId == null) {
            throw new NullPointerException("serverId is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        if (verifyToken == null) {
            throw new NullPointerException("verifyToken is marked non-null but is null");
        }
        this.serverId = serverId;
        this.publicKey = publicKey;
        this.verifyToken = verifyToken;
    }
}

