/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.login.client;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;

public class LoginPluginResponsePacket
implements Packet {
    private int messageId;
    private byte[] data;

    public LoginPluginResponsePacket(int messageId) {
        this(messageId, null);
    }

    public void read(NetInput in) throws IOException {
        this.messageId = in.readVarInt();
        this.data = (byte[])(in.readBoolean() ? in.readBytes(in.available()) : null);
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.messageId);
        if (this.data != null) {
            out.writeBoolean(true);
            out.writeBytes(this.data);
        } else {
            out.writeBoolean(false);
        }
    }

    public boolean isPriority() {
        return false;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginPluginResponsePacket)) {
            return false;
        }
        LoginPluginResponsePacket other = (LoginPluginResponsePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMessageId() != other.getMessageId()) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginPluginResponsePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMessageId();
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }

    public String toString() {
        return "LoginPluginResponsePacket(messageId=" + this.getMessageId() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    public LoginPluginResponsePacket withMessageId(int messageId) {
        return this.messageId == messageId ? this : new LoginPluginResponsePacket(messageId, this.data);
    }

    public LoginPluginResponsePacket withData(byte[] data) {
        return this.data == data ? this : new LoginPluginResponsePacket(this.messageId, data);
    }

    private LoginPluginResponsePacket() {
    }

    public LoginPluginResponsePacket(int messageId, byte[] data) {
        this.messageId = messageId;
        this.data = data;
    }
}

