/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.world.border;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerSetBorderLerpSizePacket
implements Packet {
    private double oldSize;
    private double newSize;
    private long lerpTime;

    public void read(NetInput in) throws IOException {
        this.oldSize = in.readDouble();
        this.newSize = in.readDouble();
        this.lerpTime = in.readVarLong();
    }

    public void write(NetOutput out) throws IOException {
        out.writeDouble(this.oldSize);
        out.writeDouble(this.newSize);
        out.writeVarLong(this.lerpTime);
    }

    public boolean isPriority() {
        return false;
    }

    public double getOldSize() {
        return this.oldSize;
    }

    public double getNewSize() {
        return this.newSize;
    }

    public long getLerpTime() {
        return this.lerpTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerSetBorderLerpSizePacket)) {
            return false;
        }
        ServerSetBorderLerpSizePacket other = (ServerSetBorderLerpSizePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getOldSize(), other.getOldSize()) != 0) {
            return false;
        }
        if (Double.compare(this.getNewSize(), other.getNewSize()) != 0) {
            return false;
        }
        return this.getLerpTime() == other.getLerpTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerSetBorderLerpSizePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $oldSize = Double.doubleToLongBits(this.getOldSize());
        result = result * 59 + (int)($oldSize >>> 32 ^ $oldSize);
        long $newSize = Double.doubleToLongBits(this.getNewSize());
        result = result * 59 + (int)($newSize >>> 32 ^ $newSize);
        long $lerpTime = this.getLerpTime();
        result = result * 59 + (int)($lerpTime >>> 32 ^ $lerpTime);
        return result;
    }

    public String toString() {
        return "ServerSetBorderLerpSizePacket(oldSize=" + this.getOldSize() + ", newSize=" + this.getNewSize() + ", lerpTime=" + this.getLerpTime() + ")";
    }

    public ServerSetBorderLerpSizePacket withOldSize(double oldSize) {
        return this.oldSize == oldSize ? this : new ServerSetBorderLerpSizePacket(oldSize, this.newSize, this.lerpTime);
    }

    public ServerSetBorderLerpSizePacket withNewSize(double newSize) {
        return this.newSize == newSize ? this : new ServerSetBorderLerpSizePacket(this.oldSize, newSize, this.lerpTime);
    }

    public ServerSetBorderLerpSizePacket withLerpTime(long lerpTime) {
        return this.lerpTime == lerpTime ? this : new ServerSetBorderLerpSizePacket(this.oldSize, this.newSize, lerpTime);
    }

    private ServerSetBorderLerpSizePacket() {
    }

    public ServerSetBorderLerpSizePacket(double oldSize, double newSize, long lerpTime) {
        this.oldSize = oldSize;
        this.newSize = newSize;
        this.lerpTime = lerpTime;
    }
}

