/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.world;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerUpdateTimePacket
implements Packet {
    private long worldAge;
    private long time;

    public void read(NetInput in) throws IOException {
        this.worldAge = in.readLong();
        this.time = in.readLong();
    }

    public void write(NetOutput out) throws IOException {
        out.writeLong(this.worldAge);
        out.writeLong(this.time);
    }

    public boolean isPriority() {
        return false;
    }

    public long getWorldAge() {
        return this.worldAge;
    }

    public long getTime() {
        return this.time;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerUpdateTimePacket)) {
            return false;
        }
        ServerUpdateTimePacket other = (ServerUpdateTimePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWorldAge() != other.getWorldAge()) {
            return false;
        }
        return this.getTime() == other.getTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerUpdateTimePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $worldAge = this.getWorldAge();
        result = result * 59 + (int)($worldAge >>> 32 ^ $worldAge);
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        return result;
    }

    public String toString() {
        return "ServerUpdateTimePacket(worldAge=" + this.getWorldAge() + ", time=" + this.getTime() + ")";
    }

    public ServerUpdateTimePacket withWorldAge(long worldAge) {
        return this.worldAge == worldAge ? this : new ServerUpdateTimePacket(worldAge, this.time);
    }

    public ServerUpdateTimePacket withTime(long time) {
        return this.time == time ? this : new ServerUpdateTimePacket(this.worldAge, time);
    }

    private ServerUpdateTimePacket() {
    }

    public ServerUpdateTimePacket(long worldAge, long time) {
        this.worldAge = worldAge;
        this.time = time;
    }
}

