/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.world;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.NBT;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.world.block.UpdatedTileType;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerUpdateTileEntityPacket
implements Packet {
    @NonNull
    private Position position;
    @NonNull
    private UpdatedTileType type;
    @NonNull
    private CompoundTag nbt;

    public void read(NetInput in) throws IOException {
        this.position = Position.read(in);
        this.type = MagicValues.key(UpdatedTileType.class, in.readUnsignedByte());
        this.nbt = NBT.read(in);
    }

    public void write(NetOutput out) throws IOException {
        Position.write(out, this.position);
        out.writeByte(MagicValues.value(Integer.class, (Object)this.type).intValue());
        NBT.write(out, this.nbt);
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    @NonNull
    public UpdatedTileType getType() {
        return this.type;
    }

    @NonNull
    public CompoundTag getNbt() {
        return this.nbt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerUpdateTileEntityPacket)) {
            return false;
        }
        ServerUpdateTileEntityPacket other = (ServerUpdateTileEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        UpdatedTileType this$type = this.getType();
        UpdatedTileType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        CompoundTag this$nbt = this.getNbt();
        CompoundTag other$nbt = other.getNbt();
        return !(this$nbt == null ? other$nbt != null : !this$nbt.equals(other$nbt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerUpdateTileEntityPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        UpdatedTileType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        CompoundTag $nbt = this.getNbt();
        result = result * 59 + ($nbt == null ? 43 : $nbt.hashCode());
        return result;
    }

    public String toString() {
        return "ServerUpdateTileEntityPacket(position=" + this.getPosition() + ", type=" + (Object)((Object)this.getType()) + ", nbt=" + this.getNbt() + ")";
    }

    public ServerUpdateTileEntityPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerUpdateTileEntityPacket(position, this.type, this.nbt);
    }

    public ServerUpdateTileEntityPacket withType(@NonNull UpdatedTileType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new ServerUpdateTileEntityPacket(this.position, type, this.nbt);
    }

    public ServerUpdateTileEntityPacket withNbt(@NonNull CompoundTag nbt) {
        if (nbt == null) {
            throw new NullPointerException("nbt is marked non-null but is null");
        }
        return this.nbt == nbt ? this : new ServerUpdateTileEntityPacket(this.position, this.type, nbt);
    }

    private ServerUpdateTileEntityPacket() {
    }

    public ServerUpdateTileEntityPacket(@NonNull Position position, @NonNull UpdatedTileType type, @NonNull CompoundTag nbt) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (nbt == null) {
            throw new NullPointerException("nbt is marked non-null but is null");
        }
        this.position = position;
        this.type = type;
        this.nbt = nbt;
    }
}

