/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.world;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import lombok.NonNull;

public class ServerUpdateLightPacket
implements Packet {
    private int x;
    private int z;
    @NonNull
    private BitSet skyYMask;
    @NonNull
    private BitSet blockYMask;
    @NonNull
    private BitSet emptySkyYMask;
    @NonNull
    private BitSet emptyBlockYMask;
    @NonNull
    private List<byte[]> skyUpdates;
    @NonNull
    private List<byte[]> blockUpdates;
    private boolean trustEdges;

    public ServerUpdateLightPacket(int x, int z, @NonNull BitSet skyYMask, @NonNull BitSet blockYMask, @NonNull BitSet emptySkyYMask, @NonNull BitSet emptyBlockYMask, @NonNull List<byte[]> skyUpdates, @NonNull List<byte[]> blockUpdates, boolean trustEdges) {
        if (skyYMask == null) {
            throw new NullPointerException("skyYMask is marked non-null but is null");
        }
        if (blockYMask == null) {
            throw new NullPointerException("blockYMask is marked non-null but is null");
        }
        if (emptySkyYMask == null) {
            throw new NullPointerException("emptySkyYMask is marked non-null but is null");
        }
        if (emptyBlockYMask == null) {
            throw new NullPointerException("emptyBlockYMask is marked non-null but is null");
        }
        if (skyUpdates == null) {
            throw new NullPointerException("skyUpdates is marked non-null but is null");
        }
        if (blockUpdates == null) {
            throw new NullPointerException("blockUpdates is marked non-null but is null");
        }
        for (byte[] content : skyUpdates) {
            if (content.length == 2048) continue;
            throw new IllegalArgumentException("All arrays in skyUpdates must be length of 2048!");
        }
        for (byte[] content : blockUpdates) {
            if (content.length == 2048) continue;
            throw new IllegalArgumentException("All arrays in blockUpdates must be length of 2048!");
        }
        this.x = x;
        this.z = z;
        this.skyYMask = skyYMask;
        this.blockYMask = blockYMask;
        this.emptySkyYMask = emptySkyYMask;
        this.emptyBlockYMask = emptyBlockYMask;
        this.skyUpdates = skyUpdates;
        this.blockUpdates = blockUpdates;
        this.trustEdges = trustEdges;
    }

    public void read(NetInput in) throws IOException {
        this.x = in.readVarInt();
        this.z = in.readVarInt();
        this.trustEdges = in.readBoolean();
        this.skyYMask = BitSet.valueOf(in.readLongs(in.readVarInt()));
        this.blockYMask = BitSet.valueOf(in.readLongs(in.readVarInt()));
        this.emptySkyYMask = BitSet.valueOf(in.readLongs(in.readVarInt()));
        this.emptyBlockYMask = BitSet.valueOf(in.readLongs(in.readVarInt()));
        int skyUpdateSize = in.readVarInt();
        this.skyUpdates = new ArrayList<byte[]>(skyUpdateSize);
        for (int i = 0; i < skyUpdateSize; ++i) {
            this.skyUpdates.add(in.readBytes(in.readVarInt()));
        }
        int blockUpdateSize = in.readVarInt();
        this.blockUpdates = new ArrayList<byte[]>(blockUpdateSize);
        for (int i = 0; i < blockUpdateSize; ++i) {
            this.blockUpdates.add(in.readBytes(in.readVarInt()));
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.x);
        out.writeVarInt(this.z);
        out.writeBoolean(this.trustEdges);
        this.writeBitSet(out, this.skyYMask);
        this.writeBitSet(out, this.blockYMask);
        this.writeBitSet(out, this.emptySkyYMask);
        this.writeBitSet(out, this.emptyBlockYMask);
        out.writeVarInt(this.skyUpdates.size());
        for (byte[] array : this.skyUpdates) {
            out.writeVarInt(array.length);
            out.writeBytes(array);
        }
        out.writeVarInt(this.blockUpdates.size());
        for (byte[] array : this.blockUpdates) {
            out.writeVarInt(array.length);
            out.writeBytes(array);
        }
    }

    public boolean isPriority() {
        return false;
    }

    private void writeBitSet(NetOutput out, BitSet bitSet) throws IOException {
        long[] array = bitSet.toLongArray();
        out.writeVarInt(array.length);
        for (long content : array) {
            out.writeLong(content);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    @NonNull
    public BitSet getSkyYMask() {
        return this.skyYMask;
    }

    @NonNull
    public BitSet getBlockYMask() {
        return this.blockYMask;
    }

    @NonNull
    public BitSet getEmptySkyYMask() {
        return this.emptySkyYMask;
    }

    @NonNull
    public BitSet getEmptyBlockYMask() {
        return this.emptyBlockYMask;
    }

    @NonNull
    public List<byte[]> getSkyUpdates() {
        return this.skyUpdates;
    }

    @NonNull
    public List<byte[]> getBlockUpdates() {
        return this.blockUpdates;
    }

    public boolean isTrustEdges() {
        return this.trustEdges;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerUpdateLightPacket)) {
            return false;
        }
        ServerUpdateLightPacket other = (ServerUpdateLightPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getZ() != other.getZ()) {
            return false;
        }
        if (this.isTrustEdges() != other.isTrustEdges()) {
            return false;
        }
        BitSet this$skyYMask = this.getSkyYMask();
        BitSet other$skyYMask = other.getSkyYMask();
        if (this$skyYMask == null ? other$skyYMask != null : !((Object)this$skyYMask).equals(other$skyYMask)) {
            return false;
        }
        BitSet this$blockYMask = this.getBlockYMask();
        BitSet other$blockYMask = other.getBlockYMask();
        if (this$blockYMask == null ? other$blockYMask != null : !((Object)this$blockYMask).equals(other$blockYMask)) {
            return false;
        }
        BitSet this$emptySkyYMask = this.getEmptySkyYMask();
        BitSet other$emptySkyYMask = other.getEmptySkyYMask();
        if (this$emptySkyYMask == null ? other$emptySkyYMask != null : !((Object)this$emptySkyYMask).equals(other$emptySkyYMask)) {
            return false;
        }
        BitSet this$emptyBlockYMask = this.getEmptyBlockYMask();
        BitSet other$emptyBlockYMask = other.getEmptyBlockYMask();
        if (this$emptyBlockYMask == null ? other$emptyBlockYMask != null : !((Object)this$emptyBlockYMask).equals(other$emptyBlockYMask)) {
            return false;
        }
        List<byte[]> this$skyUpdates = this.getSkyUpdates();
        List<byte[]> other$skyUpdates = other.getSkyUpdates();
        if (this$skyUpdates == null ? other$skyUpdates != null : !((Object)this$skyUpdates).equals(other$skyUpdates)) {
            return false;
        }
        List<byte[]> this$blockUpdates = this.getBlockUpdates();
        List<byte[]> other$blockUpdates = other.getBlockUpdates();
        return !(this$blockUpdates == null ? other$blockUpdates != null : !((Object)this$blockUpdates).equals(other$blockUpdates));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerUpdateLightPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getZ();
        result = result * 59 + (this.isTrustEdges() ? 79 : 97);
        BitSet $skyYMask = this.getSkyYMask();
        result = result * 59 + ($skyYMask == null ? 43 : ((Object)$skyYMask).hashCode());
        BitSet $blockYMask = this.getBlockYMask();
        result = result * 59 + ($blockYMask == null ? 43 : ((Object)$blockYMask).hashCode());
        BitSet $emptySkyYMask = this.getEmptySkyYMask();
        result = result * 59 + ($emptySkyYMask == null ? 43 : ((Object)$emptySkyYMask).hashCode());
        BitSet $emptyBlockYMask = this.getEmptyBlockYMask();
        result = result * 59 + ($emptyBlockYMask == null ? 43 : ((Object)$emptyBlockYMask).hashCode());
        List<byte[]> $skyUpdates = this.getSkyUpdates();
        result = result * 59 + ($skyUpdates == null ? 43 : ((Object)$skyUpdates).hashCode());
        List<byte[]> $blockUpdates = this.getBlockUpdates();
        result = result * 59 + ($blockUpdates == null ? 43 : ((Object)$blockUpdates).hashCode());
        return result;
    }

    public String toString() {
        return "ServerUpdateLightPacket(x=" + this.getX() + ", z=" + this.getZ() + ", skyYMask=" + this.getSkyYMask() + ", blockYMask=" + this.getBlockYMask() + ", emptySkyYMask=" + this.getEmptySkyYMask() + ", emptyBlockYMask=" + this.getEmptyBlockYMask() + ", skyUpdates=" + this.getSkyUpdates() + ", blockUpdates=" + this.getBlockUpdates() + ", trustEdges=" + this.isTrustEdges() + ")";
    }

    public ServerUpdateLightPacket withX(int x) {
        return this.x == x ? this : new ServerUpdateLightPacket(x, this.z, this.skyYMask, this.blockYMask, this.emptySkyYMask, this.emptyBlockYMask, this.skyUpdates, this.blockUpdates, this.trustEdges);
    }

    public ServerUpdateLightPacket withZ(int z) {
        return this.z == z ? this : new ServerUpdateLightPacket(this.x, z, this.skyYMask, this.blockYMask, this.emptySkyYMask, this.emptyBlockYMask, this.skyUpdates, this.blockUpdates, this.trustEdges);
    }

    public ServerUpdateLightPacket withSkyYMask(@NonNull BitSet skyYMask) {
        if (skyYMask == null) {
            throw new NullPointerException("skyYMask is marked non-null but is null");
        }
        return this.skyYMask == skyYMask ? this : new ServerUpdateLightPacket(this.x, this.z, skyYMask, this.blockYMask, this.emptySkyYMask, this.emptyBlockYMask, this.skyUpdates, this.blockUpdates, this.trustEdges);
    }

    public ServerUpdateLightPacket withBlockYMask(@NonNull BitSet blockYMask) {
        if (blockYMask == null) {
            throw new NullPointerException("blockYMask is marked non-null but is null");
        }
        return this.blockYMask == blockYMask ? this : new ServerUpdateLightPacket(this.x, this.z, this.skyYMask, blockYMask, this.emptySkyYMask, this.emptyBlockYMask, this.skyUpdates, this.blockUpdates, this.trustEdges);
    }

    public ServerUpdateLightPacket withEmptySkyYMask(@NonNull BitSet emptySkyYMask) {
        if (emptySkyYMask == null) {
            throw new NullPointerException("emptySkyYMask is marked non-null but is null");
        }
        return this.emptySkyYMask == emptySkyYMask ? this : new ServerUpdateLightPacket(this.x, this.z, this.skyYMask, this.blockYMask, emptySkyYMask, this.emptyBlockYMask, this.skyUpdates, this.blockUpdates, this.trustEdges);
    }

    public ServerUpdateLightPacket withEmptyBlockYMask(@NonNull BitSet emptyBlockYMask) {
        if (emptyBlockYMask == null) {
            throw new NullPointerException("emptyBlockYMask is marked non-null but is null");
        }
        return this.emptyBlockYMask == emptyBlockYMask ? this : new ServerUpdateLightPacket(this.x, this.z, this.skyYMask, this.blockYMask, this.emptySkyYMask, emptyBlockYMask, this.skyUpdates, this.blockUpdates, this.trustEdges);
    }

    public ServerUpdateLightPacket withSkyUpdates(@NonNull List<byte[]> skyUpdates) {
        if (skyUpdates == null) {
            throw new NullPointerException("skyUpdates is marked non-null but is null");
        }
        return this.skyUpdates == skyUpdates ? this : new ServerUpdateLightPacket(this.x, this.z, this.skyYMask, this.blockYMask, this.emptySkyYMask, this.emptyBlockYMask, skyUpdates, this.blockUpdates, this.trustEdges);
    }

    public ServerUpdateLightPacket withBlockUpdates(@NonNull List<byte[]> blockUpdates) {
        if (blockUpdates == null) {
            throw new NullPointerException("blockUpdates is marked non-null but is null");
        }
        return this.blockUpdates == blockUpdates ? this : new ServerUpdateLightPacket(this.x, this.z, this.skyYMask, this.blockYMask, this.emptySkyYMask, this.emptyBlockYMask, this.skyUpdates, blockUpdates, this.trustEdges);
    }

    public ServerUpdateLightPacket withTrustEdges(boolean trustEdges) {
        return this.trustEdges == trustEdges ? this : new ServerUpdateLightPacket(this.x, this.z, this.skyYMask, this.blockYMask, this.emptySkyYMask, this.emptyBlockYMask, this.skyUpdates, this.blockUpdates, trustEdges);
    }

    private ServerUpdateLightPacket() {
    }
}

