/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.world;

import com.github.steveice10.mc.protocol.data.game.world.particle.Particle;
import com.github.steveice10.mc.protocol.data.game.world.particle.ParticleData;
import com.github.steveice10.mc.protocol.data.game.world.particle.ParticleType;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerSpawnParticlePacket
implements Packet {
    @NonNull
    private Particle particle;
    private boolean longDistance;
    private double x;
    private double y;
    private double z;
    private float offsetX;
    private float offsetY;
    private float offsetZ;
    private float velocityOffset;
    private int amount;

    public void read(NetInput in) throws IOException {
        ParticleType type = ParticleType.VALUES[in.readInt()];
        this.longDistance = in.readBoolean();
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.offsetX = in.readFloat();
        this.offsetY = in.readFloat();
        this.offsetZ = in.readFloat();
        this.velocityOffset = in.readFloat();
        this.amount = in.readInt();
        this.particle = new Particle(type, ParticleData.read(in, type));
    }

    public void write(NetOutput out) throws IOException {
        out.writeInt(this.particle.getType().ordinal());
        out.writeBoolean(this.longDistance);
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeFloat(this.offsetX);
        out.writeFloat(this.offsetY);
        out.writeFloat(this.offsetZ);
        out.writeFloat(this.velocityOffset);
        out.writeInt(this.amount);
        ParticleData.write(out, this.particle.getType(), this.particle.getData());
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public Particle getParticle() {
        return this.particle;
    }

    public boolean isLongDistance() {
        return this.longDistance;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public float getOffsetZ() {
        return this.offsetZ;
    }

    public float getVelocityOffset() {
        return this.velocityOffset;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerSpawnParticlePacket)) {
            return false;
        }
        ServerSpawnParticlePacket other = (ServerSpawnParticlePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLongDistance() != other.isLongDistance()) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getOffsetX(), other.getOffsetX()) != 0) {
            return false;
        }
        if (Float.compare(this.getOffsetY(), other.getOffsetY()) != 0) {
            return false;
        }
        if (Float.compare(this.getOffsetZ(), other.getOffsetZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getVelocityOffset(), other.getVelocityOffset()) != 0) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        Particle this$particle = this.getParticle();
        Particle other$particle = other.getParticle();
        return !(this$particle == null ? other$particle != null : !((Object)this$particle).equals(other$particle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerSpawnParticlePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLongDistance() ? 79 : 97);
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getOffsetX());
        result = result * 59 + Float.floatToIntBits(this.getOffsetY());
        result = result * 59 + Float.floatToIntBits(this.getOffsetZ());
        result = result * 59 + Float.floatToIntBits(this.getVelocityOffset());
        result = result * 59 + this.getAmount();
        Particle $particle = this.getParticle();
        result = result * 59 + ($particle == null ? 43 : ((Object)$particle).hashCode());
        return result;
    }

    public String toString() {
        return "ServerSpawnParticlePacket(particle=" + this.getParticle() + ", longDistance=" + this.isLongDistance() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", offsetX=" + this.getOffsetX() + ", offsetY=" + this.getOffsetY() + ", offsetZ=" + this.getOffsetZ() + ", velocityOffset=" + this.getVelocityOffset() + ", amount=" + this.getAmount() + ")";
    }

    public ServerSpawnParticlePacket withParticle(@NonNull Particle particle) {
        if (particle == null) {
            throw new NullPointerException("particle is marked non-null but is null");
        }
        return this.particle == particle ? this : new ServerSpawnParticlePacket(particle, this.longDistance, this.x, this.y, this.z, this.offsetX, this.offsetY, this.offsetZ, this.velocityOffset, this.amount);
    }

    public ServerSpawnParticlePacket withLongDistance(boolean longDistance) {
        return this.longDistance == longDistance ? this : new ServerSpawnParticlePacket(this.particle, longDistance, this.x, this.y, this.z, this.offsetX, this.offsetY, this.offsetZ, this.velocityOffset, this.amount);
    }

    public ServerSpawnParticlePacket withX(double x) {
        return this.x == x ? this : new ServerSpawnParticlePacket(this.particle, this.longDistance, x, this.y, this.z, this.offsetX, this.offsetY, this.offsetZ, this.velocityOffset, this.amount);
    }

    public ServerSpawnParticlePacket withY(double y) {
        return this.y == y ? this : new ServerSpawnParticlePacket(this.particle, this.longDistance, this.x, y, this.z, this.offsetX, this.offsetY, this.offsetZ, this.velocityOffset, this.amount);
    }

    public ServerSpawnParticlePacket withZ(double z) {
        return this.z == z ? this : new ServerSpawnParticlePacket(this.particle, this.longDistance, this.x, this.y, z, this.offsetX, this.offsetY, this.offsetZ, this.velocityOffset, this.amount);
    }

    public ServerSpawnParticlePacket withOffsetX(float offsetX) {
        return this.offsetX == offsetX ? this : new ServerSpawnParticlePacket(this.particle, this.longDistance, this.x, this.y, this.z, offsetX, this.offsetY, this.offsetZ, this.velocityOffset, this.amount);
    }

    public ServerSpawnParticlePacket withOffsetY(float offsetY) {
        return this.offsetY == offsetY ? this : new ServerSpawnParticlePacket(this.particle, this.longDistance, this.x, this.y, this.z, this.offsetX, offsetY, this.offsetZ, this.velocityOffset, this.amount);
    }

    public ServerSpawnParticlePacket withOffsetZ(float offsetZ) {
        return this.offsetZ == offsetZ ? this : new ServerSpawnParticlePacket(this.particle, this.longDistance, this.x, this.y, this.z, this.offsetX, this.offsetY, offsetZ, this.velocityOffset, this.amount);
    }

    public ServerSpawnParticlePacket withVelocityOffset(float velocityOffset) {
        return this.velocityOffset == velocityOffset ? this : new ServerSpawnParticlePacket(this.particle, this.longDistance, this.x, this.y, this.z, this.offsetX, this.offsetY, this.offsetZ, velocityOffset, this.amount);
    }

    public ServerSpawnParticlePacket withAmount(int amount) {
        return this.amount == amount ? this : new ServerSpawnParticlePacket(this.particle, this.longDistance, this.x, this.y, this.z, this.offsetX, this.offsetY, this.offsetZ, this.velocityOffset, amount);
    }

    private ServerSpawnParticlePacket() {
    }

    public ServerSpawnParticlePacket(@NonNull Particle particle, boolean longDistance, double x, double y, double z, float offsetX, float offsetY, float offsetZ, float velocityOffset, int amount) {
        if (particle == null) {
            throw new NullPointerException("particle is marked non-null but is null");
        }
        this.particle = particle;
        this.longDistance = longDistance;
        this.x = x;
        this.y = y;
        this.z = z;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.velocityOffset = velocityOffset;
        this.amount = amount;
    }
}

