/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.world;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.UnmappedValueException;
import com.github.steveice10.mc.protocol.data.game.world.sound.BuiltinSound;
import com.github.steveice10.mc.protocol.data.game.world.sound.CustomSound;
import com.github.steveice10.mc.protocol.data.game.world.sound.Sound;
import com.github.steveice10.mc.protocol.data.game.world.sound.SoundCategory;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerPlaySoundPacket
implements Packet {
    @NonNull
    private Sound sound;
    @NonNull
    private SoundCategory category;
    private double x;
    private double y;
    private double z;
    private float volume;
    private float pitch;

    public void read(NetInput in) throws IOException {
        String value = in.readString();
        try {
            this.sound = MagicValues.key(BuiltinSound.class, value);
        }
        catch (UnmappedValueException e) {
            this.sound = new CustomSound(value);
        }
        this.category = MagicValues.key(SoundCategory.class, in.readVarInt());
        this.x = (double)in.readInt() / 8.0;
        this.y = (double)in.readInt() / 8.0;
        this.z = (double)in.readInt() / 8.0;
        this.volume = in.readFloat();
        this.pitch = in.readFloat();
    }

    public void write(NetOutput out) throws IOException {
        String value = "";
        if (this.sound instanceof CustomSound) {
            value = ((CustomSound)this.sound).getName();
        } else if (this.sound instanceof BuiltinSound) {
            value = MagicValues.value(String.class, this.sound);
        }
        out.writeString(value);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.category).intValue());
        out.writeInt((int)(this.x * 8.0));
        out.writeInt((int)(this.y * 8.0));
        out.writeInt((int)(this.z * 8.0));
        out.writeFloat(this.volume);
        out.writeFloat(this.pitch);
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public Sound getSound() {
        return this.sound;
    }

    @NonNull
    public SoundCategory getCategory() {
        return this.category;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerPlaySoundPacket)) {
            return false;
        }
        ServerPlaySoundPacket other = (ServerPlaySoundPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getVolume(), other.getVolume()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        Sound this$sound = this.getSound();
        Sound other$sound = other.getSound();
        if (this$sound == null ? other$sound != null : !this$sound.equals(other$sound)) {
            return false;
        }
        SoundCategory this$category = this.getCategory();
        SoundCategory other$category = other.getCategory();
        return !(this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerPlaySoundPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getVolume());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        Sound $sound = this.getSound();
        result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
        SoundCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerPlaySoundPacket(sound=" + this.getSound() + ", category=" + (Object)((Object)this.getCategory()) + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", volume=" + this.getVolume() + ", pitch=" + this.getPitch() + ")";
    }

    public ServerPlaySoundPacket withSound(@NonNull Sound sound) {
        if (sound == null) {
            throw new NullPointerException("sound is marked non-null but is null");
        }
        return this.sound == sound ? this : new ServerPlaySoundPacket(sound, this.category, this.x, this.y, this.z, this.volume, this.pitch);
    }

    public ServerPlaySoundPacket withCategory(@NonNull SoundCategory category) {
        if (category == null) {
            throw new NullPointerException("category is marked non-null but is null");
        }
        return this.category == category ? this : new ServerPlaySoundPacket(this.sound, category, this.x, this.y, this.z, this.volume, this.pitch);
    }

    public ServerPlaySoundPacket withX(double x) {
        return this.x == x ? this : new ServerPlaySoundPacket(this.sound, this.category, x, this.y, this.z, this.volume, this.pitch);
    }

    public ServerPlaySoundPacket withY(double y) {
        return this.y == y ? this : new ServerPlaySoundPacket(this.sound, this.category, this.x, y, this.z, this.volume, this.pitch);
    }

    public ServerPlaySoundPacket withZ(double z) {
        return this.z == z ? this : new ServerPlaySoundPacket(this.sound, this.category, this.x, this.y, z, this.volume, this.pitch);
    }

    public ServerPlaySoundPacket withVolume(float volume) {
        return this.volume == volume ? this : new ServerPlaySoundPacket(this.sound, this.category, this.x, this.y, this.z, volume, this.pitch);
    }

    public ServerPlaySoundPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ServerPlaySoundPacket(this.sound, this.category, this.x, this.y, this.z, this.volume, pitch);
    }

    private ServerPlaySoundPacket() {
    }

    public ServerPlaySoundPacket(@NonNull Sound sound, @NonNull SoundCategory category, double x, double y, double z, float volume, float pitch) {
        if (sound == null) {
            throw new NullPointerException("sound is marked non-null but is null");
        }
        if (category == null) {
            throw new NullPointerException("category is marked non-null but is null");
        }
        this.sound = sound;
        this.category = category;
        this.x = x;
        this.y = y;
        this.z = z;
        this.volume = volume;
        this.pitch = pitch;
    }
}

