/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.world;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.world.effect.BonemealGrowEffectData;
import com.github.steveice10.mc.protocol.data.game.world.effect.BreakBlockEffectData;
import com.github.steveice10.mc.protocol.data.game.world.effect.BreakPotionEffectData;
import com.github.steveice10.mc.protocol.data.game.world.effect.ComposterEffectData;
import com.github.steveice10.mc.protocol.data.game.world.effect.DragonFireballEffectData;
import com.github.steveice10.mc.protocol.data.game.world.effect.ParticleEffect;
import com.github.steveice10.mc.protocol.data.game.world.effect.RecordEffectData;
import com.github.steveice10.mc.protocol.data.game.world.effect.SmokeEffectData;
import com.github.steveice10.mc.protocol.data.game.world.effect.SoundEffect;
import com.github.steveice10.mc.protocol.data.game.world.effect.WorldEffect;
import com.github.steveice10.mc.protocol.data.game.world.effect.WorldEffectData;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerPlayEffectPacket
implements Packet {
    @NonNull
    private WorldEffect effect;
    @NonNull
    private Position position;
    @NonNull
    private WorldEffectData data;
    private boolean broadcast;

    public ServerPlayEffectPacket(@NonNull WorldEffect effect, @NonNull Position position, @NonNull WorldEffectData data) {
        this(effect, position, data, false);
        if (effect == null) {
            throw new NullPointerException("effect is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
    }

    public void read(NetInput in) throws IOException {
        this.effect = MagicValues.key(WorldEffect.class, in.readInt());
        this.position = Position.read(in);
        int value = in.readInt();
        if (this.effect == SoundEffect.RECORD) {
            this.data = new RecordEffectData(value);
        } else if (this.effect == ParticleEffect.SMOKE) {
            this.data = MagicValues.key(SmokeEffectData.class, value % 6);
        } else if (this.effect == ParticleEffect.BREAK_BLOCK) {
            this.data = new BreakBlockEffectData(value);
        } else if (this.effect == ParticleEffect.BREAK_SPLASH_POTION) {
            this.data = new BreakPotionEffectData(value);
        } else if (this.effect == ParticleEffect.BONEMEAL_GROW || this.effect == ParticleEffect.BONEMEAL_GROW_WITH_SOUND) {
            this.data = new BonemealGrowEffectData(value);
        } else if (this.effect == ParticleEffect.COMPOSTER) {
            this.data = value > 0 ? ComposterEffectData.FILL_SUCCESS : ComposterEffectData.FILL;
        } else if (this.effect == ParticleEffect.ENDERDRAGON_FIREBALL_EXPLODE) {
            this.data = value == 1 ? DragonFireballEffectData.HAS_SOUND : DragonFireballEffectData.NO_SOUND;
        }
        this.broadcast = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeInt(MagicValues.value(Integer.class, this.effect).intValue());
        Position.write(out, this.position);
        int value = 0;
        if (this.data instanceof RecordEffectData) {
            value = ((RecordEffectData)this.data).getRecordId();
        } else if (this.data instanceof SmokeEffectData) {
            value = MagicValues.value(Integer.class, (SmokeEffectData)this.data);
        } else if (this.data instanceof BreakBlockEffectData) {
            value = ((BreakBlockEffectData)this.data).getBlockState();
        } else if (this.data instanceof BreakPotionEffectData) {
            value = ((BreakPotionEffectData)this.data).getPotionId();
        } else if (this.data instanceof BonemealGrowEffectData) {
            value = ((BonemealGrowEffectData)this.data).getParticleCount();
        } else if (this.data instanceof ComposterEffectData) {
            value = MagicValues.value(Integer.class, this.data);
        } else if (this.data instanceof DragonFireballEffectData) {
            value = MagicValues.value(Integer.class, this.data);
        }
        out.writeInt(value);
        out.writeBoolean(this.broadcast);
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public WorldEffect getEffect() {
        return this.effect;
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    @NonNull
    public WorldEffectData getData() {
        return this.data;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerPlayEffectPacket)) {
            return false;
        }
        ServerPlayEffectPacket other = (ServerPlayEffectPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBroadcast() != other.isBroadcast()) {
            return false;
        }
        WorldEffect this$effect = this.getEffect();
        WorldEffect other$effect = other.getEffect();
        if (this$effect == null ? other$effect != null : !this$effect.equals(other$effect)) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        WorldEffectData this$data = this.getData();
        WorldEffectData other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerPlayEffectPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBroadcast() ? 79 : 97);
        WorldEffect $effect = this.getEffect();
        result = result * 59 + ($effect == null ? 43 : $effect.hashCode());
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        WorldEffectData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ServerPlayEffectPacket(effect=" + this.getEffect() + ", position=" + this.getPosition() + ", data=" + this.getData() + ", broadcast=" + this.isBroadcast() + ")";
    }

    public ServerPlayEffectPacket withEffect(@NonNull WorldEffect effect) {
        if (effect == null) {
            throw new NullPointerException("effect is marked non-null but is null");
        }
        return this.effect == effect ? this : new ServerPlayEffectPacket(effect, this.position, this.data, this.broadcast);
    }

    public ServerPlayEffectPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerPlayEffectPacket(this.effect, position, this.data, this.broadcast);
    }

    public ServerPlayEffectPacket withData(@NonNull WorldEffectData data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return this.data == data ? this : new ServerPlayEffectPacket(this.effect, this.position, data, this.broadcast);
    }

    public ServerPlayEffectPacket withBroadcast(boolean broadcast) {
        return this.broadcast == broadcast ? this : new ServerPlayEffectPacket(this.effect, this.position, this.data, broadcast);
    }

    private ServerPlayEffectPacket() {
    }

    public ServerPlayEffectPacket(@NonNull WorldEffect effect, @NonNull Position position, @NonNull WorldEffectData data, boolean broadcast) {
        if (effect == null) {
            throw new NullPointerException("effect is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.effect = effect;
        this.position = position;
        this.data = data;
        this.broadcast = broadcast;
    }
}

