/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.world;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.mc.protocol.data.game.world.notify.ClientNotification;
import com.github.steveice10.mc.protocol.data.game.world.notify.ClientNotificationValue;
import com.github.steveice10.mc.protocol.data.game.world.notify.DemoMessageValue;
import com.github.steveice10.mc.protocol.data.game.world.notify.EnterCreditsValue;
import com.github.steveice10.mc.protocol.data.game.world.notify.RainStrengthValue;
import com.github.steveice10.mc.protocol.data.game.world.notify.RespawnScreenValue;
import com.github.steveice10.mc.protocol.data.game.world.notify.ThunderStrengthValue;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerNotifyClientPacket
implements Packet {
    @NonNull
    private ClientNotification notification;
    @NonNull
    private ClientNotificationValue value;

    public void read(NetInput in) throws IOException {
        this.notification = MagicValues.key(ClientNotification.class, in.readUnsignedByte());
        float value = in.readFloat();
        if (this.notification == ClientNotification.CHANGE_GAMEMODE) {
            this.value = MagicValues.key(GameMode.class, (int)value == -1 ? 255 : (int)value);
        } else if (this.notification == ClientNotification.DEMO_MESSAGE) {
            this.value = MagicValues.key(DemoMessageValue.class, (int)value);
        } else if (this.notification == ClientNotification.ENTER_CREDITS) {
            this.value = MagicValues.key(EnterCreditsValue.class, (int)value);
        } else if (this.notification == ClientNotification.ENABLE_RESPAWN_SCREEN) {
            this.value = MagicValues.key(RespawnScreenValue.class, (int)value);
        } else if (this.notification == ClientNotification.RAIN_STRENGTH) {
            this.value = new RainStrengthValue(value);
        } else if (this.notification == ClientNotification.THUNDER_STRENGTH) {
            this.value = new ThunderStrengthValue(value);
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeByte(MagicValues.value(Integer.class, (Object)this.notification).intValue());
        float value = 0.0f;
        if (this.value instanceof GameMode && this.value == GameMode.UNKNOWN) {
            value = -1.0f;
        } else if (this.value instanceof Enum) {
            value = MagicValues.value(Integer.class, (Enum)((Object)this.value)).intValue();
        } else if (this.value instanceof RainStrengthValue) {
            value = ((RainStrengthValue)this.value).getStrength();
        } else if (this.value instanceof ThunderStrengthValue) {
            value = ((ThunderStrengthValue)this.value).getStrength();
        }
        out.writeFloat(value);
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public ClientNotification getNotification() {
        return this.notification;
    }

    @NonNull
    public ClientNotificationValue getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerNotifyClientPacket)) {
            return false;
        }
        ServerNotifyClientPacket other = (ServerNotifyClientPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ClientNotification this$notification = this.getNotification();
        ClientNotification other$notification = other.getNotification();
        if (this$notification == null ? other$notification != null : !((Object)((Object)this$notification)).equals((Object)other$notification)) {
            return false;
        }
        ClientNotificationValue this$value = this.getValue();
        ClientNotificationValue other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerNotifyClientPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClientNotification $notification = this.getNotification();
        result = result * 59 + ($notification == null ? 43 : ((Object)((Object)$notification)).hashCode());
        ClientNotificationValue $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "ServerNotifyClientPacket(notification=" + (Object)((Object)this.getNotification()) + ", value=" + this.getValue() + ")";
    }

    public ServerNotifyClientPacket withNotification(@NonNull ClientNotification notification) {
        if (notification == null) {
            throw new NullPointerException("notification is marked non-null but is null");
        }
        return this.notification == notification ? this : new ServerNotifyClientPacket(notification, this.value);
    }

    public ServerNotifyClientPacket withValue(@NonNull ClientNotificationValue value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.value == value ? this : new ServerNotifyClientPacket(this.notification, value);
    }

    private ServerNotifyClientPacket() {
    }

    public ServerNotifyClientPacket(@NonNull ClientNotification notification, @NonNull ClientNotificationValue value) {
        if (notification == null) {
            throw new NullPointerException("notification is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.notification = notification;
        this.value = value;
    }
}

