/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.world;

import com.github.steveice10.mc.protocol.data.game.NBT;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerNBTResponsePacket
implements Packet {
    private int transactionId;
    @NonNull
    private CompoundTag nbt;

    public void read(NetInput in) throws IOException {
        this.transactionId = in.readVarInt();
        this.nbt = NBT.read(in);
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.transactionId);
        NBT.write(out, this.nbt);
    }

    public boolean isPriority() {
        return false;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    @NonNull
    public CompoundTag getNbt() {
        return this.nbt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerNBTResponsePacket)) {
            return false;
        }
        ServerNBTResponsePacket other = (ServerNBTResponsePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        CompoundTag this$nbt = this.getNbt();
        CompoundTag other$nbt = other.getNbt();
        return !(this$nbt == null ? other$nbt != null : !this$nbt.equals(other$nbt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerNBTResponsePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        CompoundTag $nbt = this.getNbt();
        result = result * 59 + ($nbt == null ? 43 : $nbt.hashCode());
        return result;
    }

    public String toString() {
        return "ServerNBTResponsePacket(transactionId=" + this.getTransactionId() + ", nbt=" + this.getNbt() + ")";
    }

    public ServerNBTResponsePacket withTransactionId(int transactionId) {
        return this.transactionId == transactionId ? this : new ServerNBTResponsePacket(transactionId, this.nbt);
    }

    public ServerNBTResponsePacket withNbt(@NonNull CompoundTag nbt) {
        if (nbt == null) {
            throw new NullPointerException("nbt is marked non-null but is null");
        }
        return this.nbt == nbt ? this : new ServerNBTResponsePacket(this.transactionId, nbt);
    }

    private ServerNBTResponsePacket() {
    }

    public ServerNBTResponsePacket(int transactionId, @NonNull CompoundTag nbt) {
        if (nbt == null) {
            throw new NullPointerException("nbt is marked non-null but is null");
        }
        this.transactionId = transactionId;
        this.nbt = nbt;
    }
}

