/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.world;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.world.block.BlockChangeRecord;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ServerMultiBlockChangePacket
implements Packet {
    private int chunkX;
    private int chunkY;
    private int chunkZ;
    private boolean ignoreOldLight;
    @NonNull
    private BlockChangeRecord[] records;

    public ServerMultiBlockChangePacket(int chunkX, int chunkY, int chunkZ, boolean ignoreOldLight, BlockChangeRecord ... records) {
        if (records == null || records.length == 0) {
            throw new IllegalArgumentException("Records must contain at least 1 value.");
        }
        this.chunkX = chunkX;
        this.chunkY = chunkY;
        this.chunkZ = chunkZ;
        this.ignoreOldLight = ignoreOldLight;
        this.records = records;
    }

    public void read(NetInput in) throws IOException {
        long chunkPosition = in.readLong();
        this.chunkX = (int)(chunkPosition >> 42);
        this.chunkY = (int)(chunkPosition << 44 >> 44);
        this.chunkZ = (int)(chunkPosition << 22 >> 42);
        this.ignoreOldLight = in.readBoolean();
        this.records = new BlockChangeRecord[in.readVarInt()];
        for (int index = 0; index < this.records.length; ++index) {
            long blockData = in.readVarLong();
            short position = (short)(blockData & 0xFFFL);
            int x = (this.chunkX << 4) + (position >>> 8 & 0xF);
            int y = (this.chunkY << 4) + (position & 0xF);
            int z = (this.chunkZ << 4) + (position >>> 4 & 0xF);
            this.records[index] = new BlockChangeRecord(new Position(x, y, z), (int)(blockData >>> 12));
        }
    }

    public void write(NetOutput out) throws IOException {
        long chunkPosition = 0L;
        chunkPosition |= ((long)this.chunkX & 0x3FFFFFL) << 42;
        out.writeLong((chunkPosition |= ((long)this.chunkZ & 0x3FFFFFL) << 20) | (long)this.chunkY & 0xFFFFFL);
        out.writeBoolean(this.ignoreOldLight);
        out.writeVarInt(this.records.length);
        for (BlockChangeRecord record : this.records) {
            short position = (short)(record.getPosition().getX() - (this.chunkX << 4) << 8 | record.getPosition().getZ() - (this.chunkZ << 4) << 4 | record.getPosition().getY() - (this.chunkY << 4));
            out.writeVarLong((long)record.getBlock() << 12 | (long)position);
        }
    }

    public boolean isPriority() {
        return false;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkY() {
        return this.chunkY;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public boolean isIgnoreOldLight() {
        return this.ignoreOldLight;
    }

    @NonNull
    public BlockChangeRecord[] getRecords() {
        return this.records;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerMultiBlockChangePacket)) {
            return false;
        }
        ServerMultiBlockChangePacket other = (ServerMultiBlockChangePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getChunkX() != other.getChunkX()) {
            return false;
        }
        if (this.getChunkY() != other.getChunkY()) {
            return false;
        }
        if (this.getChunkZ() != other.getChunkZ()) {
            return false;
        }
        if (this.isIgnoreOldLight() != other.isIgnoreOldLight()) {
            return false;
        }
        return Arrays.deepEquals(this.getRecords(), other.getRecords());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerMultiBlockChangePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getChunkX();
        result = result * 59 + this.getChunkY();
        result = result * 59 + this.getChunkZ();
        result = result * 59 + (this.isIgnoreOldLight() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getRecords());
        return result;
    }

    public String toString() {
        return "ServerMultiBlockChangePacket(chunkX=" + this.getChunkX() + ", chunkY=" + this.getChunkY() + ", chunkZ=" + this.getChunkZ() + ", ignoreOldLight=" + this.isIgnoreOldLight() + ", records=" + Arrays.deepToString(this.getRecords()) + ")";
    }

    public ServerMultiBlockChangePacket withChunkX(int chunkX) {
        return this.chunkX == chunkX ? this : new ServerMultiBlockChangePacket(chunkX, this.chunkY, this.chunkZ, this.ignoreOldLight, this.records);
    }

    public ServerMultiBlockChangePacket withChunkY(int chunkY) {
        return this.chunkY == chunkY ? this : new ServerMultiBlockChangePacket(this.chunkX, chunkY, this.chunkZ, this.ignoreOldLight, this.records);
    }

    public ServerMultiBlockChangePacket withChunkZ(int chunkZ) {
        return this.chunkZ == chunkZ ? this : new ServerMultiBlockChangePacket(this.chunkX, this.chunkY, chunkZ, this.ignoreOldLight, this.records);
    }

    public ServerMultiBlockChangePacket withIgnoreOldLight(boolean ignoreOldLight) {
        return this.ignoreOldLight == ignoreOldLight ? this : new ServerMultiBlockChangePacket(this.chunkX, this.chunkY, this.chunkZ, ignoreOldLight, this.records);
    }

    public ServerMultiBlockChangePacket withRecords(@NonNull BlockChangeRecord[] records) {
        if (records == null) {
            throw new NullPointerException("records is marked non-null but is null");
        }
        return this.records == records ? this : new ServerMultiBlockChangePacket(this.chunkX, this.chunkY, this.chunkZ, this.ignoreOldLight, records);
    }

    private ServerMultiBlockChangePacket() {
    }
}

