/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.world;

import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.world.map.MapData;
import com.github.steveice10.mc.protocol.data.game.world.map.MapIcon;
import com.github.steveice10.mc.protocol.data.game.world.map.MapIconType;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class ServerMapDataPacket
implements Packet {
    private int mapId;
    private byte scale;
    private boolean locked;
    @NonNull
    private MapIcon[] icons;
    private MapData data;

    public ServerMapDataPacket(int mapId, byte scale, boolean locked, @NonNull MapIcon[] icons) {
        this(mapId, scale, locked, icons, null);
        if (icons == null) {
            throw new NullPointerException("icons is marked non-null but is null");
        }
    }

    public void read(NetInput in) throws IOException {
        int columns;
        int x;
        this.mapId = in.readVarInt();
        this.scale = in.readByte();
        this.locked = in.readBoolean();
        boolean hasIcons = in.readBoolean();
        this.icons = new MapIcon[hasIcons ? in.readVarInt() : 0];
        if (hasIcons) {
            for (int index = 0; index < this.icons.length; ++index) {
                int type = in.readVarInt();
                x = in.readUnsignedByte();
                int z = in.readUnsignedByte();
                int rotation = in.readUnsignedByte();
                Component displayName = null;
                if (in.readBoolean()) {
                    displayName = DefaultComponentSerializer.get().deserialize((Object)in.readString());
                }
                this.icons[index] = new MapIcon(x, z, MagicValues.key(MapIconType.class, type), rotation, displayName);
            }
        }
        if ((columns = in.readUnsignedByte()) > 0) {
            int rows = in.readUnsignedByte();
            x = in.readUnsignedByte();
            int y = in.readUnsignedByte();
            byte[] data = in.readBytes(in.readVarInt());
            this.data = new MapData(columns, rows, x, y, data);
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.mapId);
        out.writeByte((int)this.scale);
        out.writeBoolean(this.locked);
        if (this.icons.length != 0) {
            out.writeBoolean(true);
            out.writeVarInt(this.icons.length);
            for (MapIcon icon : this.icons) {
                int type = MagicValues.value(Integer.class, (Object)icon.getIconType());
                out.writeVarInt(type);
                out.writeByte(icon.getCenterX());
                out.writeByte(icon.getCenterZ());
                out.writeByte(icon.getIconRotation());
                if (icon.getDisplayName() != null) {
                    out.writeBoolean(true);
                    out.writeString((String)DefaultComponentSerializer.get().serialize(icon.getDisplayName()));
                    continue;
                }
                out.writeBoolean(false);
            }
        } else {
            out.writeBoolean(false);
        }
        if (this.data != null && this.data.getColumns() != 0) {
            out.writeByte(this.data.getColumns());
            out.writeByte(this.data.getRows());
            out.writeByte(this.data.getX());
            out.writeByte(this.data.getY());
            out.writeVarInt(this.data.getData().length);
            out.writeBytes(this.data.getData());
        } else {
            out.writeByte(0);
        }
    }

    public boolean isPriority() {
        return false;
    }

    public int getMapId() {
        return this.mapId;
    }

    public byte getScale() {
        return this.scale;
    }

    public boolean isLocked() {
        return this.locked;
    }

    @NonNull
    public MapIcon[] getIcons() {
        return this.icons;
    }

    public MapData getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerMapDataPacket)) {
            return false;
        }
        ServerMapDataPacket other = (ServerMapDataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMapId() != other.getMapId()) {
            return false;
        }
        if (this.getScale() != other.getScale()) {
            return false;
        }
        if (this.isLocked() != other.isLocked()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIcons(), other.getIcons())) {
            return false;
        }
        MapData this$data = this.getData();
        MapData other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerMapDataPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMapId();
        result = result * 59 + this.getScale();
        result = result * 59 + (this.isLocked() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getIcons());
        MapData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "ServerMapDataPacket(mapId=" + this.getMapId() + ", scale=" + this.getScale() + ", locked=" + this.isLocked() + ", icons=" + Arrays.deepToString(this.getIcons()) + ", data=" + this.getData() + ")";
    }

    public ServerMapDataPacket withMapId(int mapId) {
        return this.mapId == mapId ? this : new ServerMapDataPacket(mapId, this.scale, this.locked, this.icons, this.data);
    }

    public ServerMapDataPacket withScale(byte scale) {
        return this.scale == scale ? this : new ServerMapDataPacket(this.mapId, scale, this.locked, this.icons, this.data);
    }

    public ServerMapDataPacket withLocked(boolean locked) {
        return this.locked == locked ? this : new ServerMapDataPacket(this.mapId, this.scale, locked, this.icons, this.data);
    }

    public ServerMapDataPacket withIcons(@NonNull MapIcon[] icons) {
        if (icons == null) {
            throw new NullPointerException("icons is marked non-null but is null");
        }
        return this.icons == icons ? this : new ServerMapDataPacket(this.mapId, this.scale, this.locked, icons, this.data);
    }

    public ServerMapDataPacket withData(MapData data) {
        return this.data == data ? this : new ServerMapDataPacket(this.mapId, this.scale, this.locked, this.icons, data);
    }

    private ServerMapDataPacket() {
    }

    public ServerMapDataPacket(int mapId, byte scale, boolean locked, @NonNull MapIcon[] icons, MapData data) {
        if (icons == null) {
            throw new NullPointerException("icons is marked non-null but is null");
        }
        this.mapId = mapId;
        this.scale = scale;
        this.locked = locked;
        this.icons = icons;
        this.data = data;
    }
}

