/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.world;

import com.github.steveice10.mc.protocol.data.game.world.block.ExplodedBlockRecord;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class ServerExplosionPacket
implements Packet {
    private float x;
    private float y;
    private float z;
    private float radius;
    @NonNull
    private List<ExplodedBlockRecord> exploded;
    private float pushX;
    private float pushY;
    private float pushZ;

    public void read(NetInput in) throws IOException {
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.z = in.readFloat();
        this.radius = in.readFloat();
        this.exploded = new ArrayList<ExplodedBlockRecord>();
        int length = in.readVarInt();
        for (int count = 0; count < length; ++count) {
            this.exploded.add(new ExplodedBlockRecord(in.readByte(), in.readByte(), in.readByte()));
        }
        this.pushX = in.readFloat();
        this.pushY = in.readFloat();
        this.pushZ = in.readFloat();
    }

    public void write(NetOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.z);
        out.writeFloat(this.radius);
        out.writeVarInt(this.exploded.size());
        for (ExplodedBlockRecord record : this.exploded) {
            out.writeByte(record.getX());
            out.writeByte(record.getY());
            out.writeByte(record.getZ());
        }
        out.writeFloat(this.pushX);
        out.writeFloat(this.pushY);
        out.writeFloat(this.pushZ);
    }

    public boolean isPriority() {
        return false;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getRadius() {
        return this.radius;
    }

    @NonNull
    public List<ExplodedBlockRecord> getExploded() {
        return this.exploded;
    }

    public float getPushX() {
        return this.pushX;
    }

    public float getPushY() {
        return this.pushY;
    }

    public float getPushZ() {
        return this.pushZ;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerExplosionPacket)) {
            return false;
        }
        ServerExplosionPacket other = (ServerExplosionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Float.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getRadius(), other.getRadius()) != 0) {
            return false;
        }
        if (Float.compare(this.getPushX(), other.getPushX()) != 0) {
            return false;
        }
        if (Float.compare(this.getPushY(), other.getPushY()) != 0) {
            return false;
        }
        if (Float.compare(this.getPushZ(), other.getPushZ()) != 0) {
            return false;
        }
        List<ExplodedBlockRecord> this$exploded = this.getExploded();
        List<ExplodedBlockRecord> other$exploded = other.getExploded();
        return !(this$exploded == null ? other$exploded != null : !((Object)this$exploded).equals(other$exploded));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerExplosionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        result = result * 59 + Float.floatToIntBits(this.getZ());
        result = result * 59 + Float.floatToIntBits(this.getRadius());
        result = result * 59 + Float.floatToIntBits(this.getPushX());
        result = result * 59 + Float.floatToIntBits(this.getPushY());
        result = result * 59 + Float.floatToIntBits(this.getPushZ());
        List<ExplodedBlockRecord> $exploded = this.getExploded();
        result = result * 59 + ($exploded == null ? 43 : ((Object)$exploded).hashCode());
        return result;
    }

    public String toString() {
        return "ServerExplosionPacket(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", radius=" + this.getRadius() + ", exploded=" + this.getExploded() + ", pushX=" + this.getPushX() + ", pushY=" + this.getPushY() + ", pushZ=" + this.getPushZ() + ")";
    }

    public ServerExplosionPacket withX(float x) {
        return this.x == x ? this : new ServerExplosionPacket(x, this.y, this.z, this.radius, this.exploded, this.pushX, this.pushY, this.pushZ);
    }

    public ServerExplosionPacket withY(float y) {
        return this.y == y ? this : new ServerExplosionPacket(this.x, y, this.z, this.radius, this.exploded, this.pushX, this.pushY, this.pushZ);
    }

    public ServerExplosionPacket withZ(float z) {
        return this.z == z ? this : new ServerExplosionPacket(this.x, this.y, z, this.radius, this.exploded, this.pushX, this.pushY, this.pushZ);
    }

    public ServerExplosionPacket withRadius(float radius) {
        return this.radius == radius ? this : new ServerExplosionPacket(this.x, this.y, this.z, radius, this.exploded, this.pushX, this.pushY, this.pushZ);
    }

    public ServerExplosionPacket withExploded(@NonNull List<ExplodedBlockRecord> exploded) {
        if (exploded == null) {
            throw new NullPointerException("exploded is marked non-null but is null");
        }
        return this.exploded == exploded ? this : new ServerExplosionPacket(this.x, this.y, this.z, this.radius, exploded, this.pushX, this.pushY, this.pushZ);
    }

    public ServerExplosionPacket withPushX(float pushX) {
        return this.pushX == pushX ? this : new ServerExplosionPacket(this.x, this.y, this.z, this.radius, this.exploded, pushX, this.pushY, this.pushZ);
    }

    public ServerExplosionPacket withPushY(float pushY) {
        return this.pushY == pushY ? this : new ServerExplosionPacket(this.x, this.y, this.z, this.radius, this.exploded, this.pushX, pushY, this.pushZ);
    }

    public ServerExplosionPacket withPushZ(float pushZ) {
        return this.pushZ == pushZ ? this : new ServerExplosionPacket(this.x, this.y, this.z, this.radius, this.exploded, this.pushX, this.pushY, pushZ);
    }

    private ServerExplosionPacket() {
    }

    public ServerExplosionPacket(float x, float y, float z, float radius, @NonNull List<ExplodedBlockRecord> exploded, float pushX, float pushY, float pushZ) {
        if (exploded == null) {
            throw new NullPointerException("exploded is marked non-null but is null");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
        this.exploded = exploded;
        this.pushX = pushX;
        this.pushY = pushY;
        this.pushZ = pushZ;
    }
}

