/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.world;

import com.github.steveice10.mc.protocol.data.game.NBT;
import com.github.steveice10.mc.protocol.data.game.chunk.Chunk;
import com.github.steveice10.mc.protocol.data.game.chunk.Column;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.io.stream.StreamNetInput;
import com.github.steveice10.packetlib.io.stream.StreamNetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import lombok.NonNull;

public class ServerChunkDataPacket
implements Packet {
    @NonNull
    private Column column;

    public void read(NetInput in) throws IOException {
        int x = in.readInt();
        int z = in.readInt();
        BitSet chunkMask = BitSet.valueOf(in.readLongs(in.readVarInt()));
        CompoundTag heightMaps = NBT.read(in);
        int[] biomeData = new int[in.readVarInt()];
        for (int index = 0; index < biomeData.length; ++index) {
            biomeData[index] = in.readVarInt();
        }
        byte[] data = in.readBytes(in.readVarInt());
        StreamNetInput dataIn = new StreamNetInput((InputStream)new ByteArrayInputStream(data));
        Chunk[] chunks = new Chunk[chunkMask.size()];
        for (int index = 0; index < chunks.length; ++index) {
            if (!chunkMask.get(index)) continue;
            chunks[index] = Chunk.read((NetInput)dataIn);
        }
        CompoundTag[] tileEntities = new CompoundTag[in.readVarInt()];
        for (int i = 0; i < tileEntities.length; ++i) {
            tileEntities[i] = NBT.read(in);
        }
        this.column = new Column(x, z, chunks, tileEntities, heightMaps, biomeData);
    }

    public void write(NetOutput out) throws IOException {
        ByteArrayOutputStream dataBytes = new ByteArrayOutputStream();
        StreamNetOutput dataOut = new StreamNetOutput((OutputStream)dataBytes);
        BitSet bitSet = new BitSet();
        Chunk[] chunks = this.column.getChunks();
        for (int index = 0; index < chunks.length; ++index) {
            Chunk chunk = chunks[index];
            if (chunk == null || chunk.isEmpty()) continue;
            bitSet.set(index);
            Chunk.write((NetOutput)dataOut, chunk);
        }
        out.writeInt(this.column.getX());
        out.writeInt(this.column.getZ());
        long[] longArray = bitSet.toLongArray();
        out.writeVarInt(longArray.length);
        for (long content : longArray) {
            out.writeLong(content);
        }
        NBT.write(out, this.column.getHeightMaps());
        out.writeVarInt(this.column.getBiomeData().length);
        for (int biomeData : this.column.getBiomeData()) {
            out.writeVarInt(biomeData);
        }
        out.writeVarInt(dataBytes.size());
        out.writeBytes(dataBytes.toByteArray(), dataBytes.size());
        out.writeVarInt(this.column.getTileEntities().length);
        for (CompoundTag tag : this.column.getTileEntities()) {
            NBT.write(out, tag);
        }
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public Column getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerChunkDataPacket)) {
            return false;
        }
        ServerChunkDataPacket other = (ServerChunkDataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Column this$column = this.getColumn();
        Column other$column = other.getColumn();
        return !(this$column == null ? other$column != null : !((Object)this$column).equals(other$column));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerChunkDataPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Column $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : ((Object)$column).hashCode());
        return result;
    }

    public String toString() {
        return "ServerChunkDataPacket(column=" + this.getColumn() + ")";
    }

    public ServerChunkDataPacket withColumn(@NonNull Column column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        return this.column == column ? this : new ServerChunkDataPacket(column);
    }

    private ServerChunkDataPacket() {
    }

    public ServerChunkDataPacket(@NonNull Column column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        this.column = column;
    }
}

