/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.world;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.world.block.value.BlockValue;
import com.github.steveice10.mc.protocol.data.game.world.block.value.BlockValueType;
import com.github.steveice10.mc.protocol.data.game.world.block.value.ChestValue;
import com.github.steveice10.mc.protocol.data.game.world.block.value.ChestValueType;
import com.github.steveice10.mc.protocol.data.game.world.block.value.EndGatewayValue;
import com.github.steveice10.mc.protocol.data.game.world.block.value.EndGatewayValueType;
import com.github.steveice10.mc.protocol.data.game.world.block.value.GenericBlockValue;
import com.github.steveice10.mc.protocol.data.game.world.block.value.GenericBlockValueType;
import com.github.steveice10.mc.protocol.data.game.world.block.value.MobSpawnerValue;
import com.github.steveice10.mc.protocol.data.game.world.block.value.MobSpawnerValueType;
import com.github.steveice10.mc.protocol.data.game.world.block.value.NoteBlockValue;
import com.github.steveice10.mc.protocol.data.game.world.block.value.NoteBlockValueType;
import com.github.steveice10.mc.protocol.data.game.world.block.value.PistonValue;
import com.github.steveice10.mc.protocol.data.game.world.block.value.PistonValueType;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerBlockValuePacket
implements Packet {
    private static final int NOTE_BLOCK = 80;
    private static final int STICKY_PISTON = 99;
    private static final int PISTON = 106;
    private static final int MOB_SPAWNER = 151;
    private static final int CHEST = 153;
    private static final int ENDER_CHEST = 283;
    private static final int TRAPPED_CHEST = 342;
    private static final int END_GATEWAY = 513;
    private static final int SHULKER_BOX_LOWER = 523;
    private static final int SHULKER_BOX_HIGHER = 539;
    @NonNull
    private Position position;
    @NonNull
    private BlockValueType type;
    @NonNull
    private BlockValue value;
    private int blockId;

    public void read(NetInput in) throws IOException {
        this.position = Position.read(in);
        int type = in.readUnsignedByte();
        int value = in.readUnsignedByte();
        this.blockId = in.readVarInt() & 0xFFF;
        if (this.blockId == 80) {
            this.type = MagicValues.key(NoteBlockValueType.class, type);
            this.value = new NoteBlockValue(value);
        } else if (this.blockId == 99 || this.blockId == 106) {
            this.type = MagicValues.key(PistonValueType.class, type);
            this.value = MagicValues.key(PistonValue.class, value);
        } else if (this.blockId == 151) {
            this.type = MagicValues.key(MobSpawnerValueType.class, type);
            this.value = new MobSpawnerValue();
        } else if (this.blockId == 153 || this.blockId == 283 || this.blockId == 342 || this.blockId >= 523 && this.blockId <= 539) {
            this.type = MagicValues.key(ChestValueType.class, type);
            this.value = new ChestValue(value);
        } else if (this.blockId == 513) {
            this.type = MagicValues.key(EndGatewayValueType.class, type);
            this.value = new EndGatewayValue();
        } else {
            this.type = MagicValues.key(GenericBlockValueType.class, type);
            this.value = new GenericBlockValue(value);
        }
    }

    public void write(NetOutput out) throws IOException {
        int val = 0;
        if (this.type instanceof NoteBlockValueType) {
            val = ((NoteBlockValue)this.value).getPitch();
        } else if (this.type instanceof PistonValueType) {
            val = MagicValues.value(Integer.class, this.value);
        } else if (this.type instanceof ChestValueType) {
            val = ((ChestValue)this.value).getViewers();
        } else if (this.type instanceof GenericBlockValueType) {
            val = ((GenericBlockValue)this.value).getValue();
        }
        Position.write(out, this.position);
        out.writeByte(MagicValues.value(Integer.class, this.type).intValue());
        out.writeByte(val);
        out.writeVarInt(this.blockId & 0xFFF);
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    @NonNull
    public BlockValueType getType() {
        return this.type;
    }

    @NonNull
    public BlockValue getValue() {
        return this.value;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerBlockValuePacket)) {
            return false;
        }
        ServerBlockValuePacket other = (ServerBlockValuePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBlockId() != other.getBlockId()) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        BlockValueType this$type = this.getType();
        BlockValueType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        BlockValue this$value = this.getValue();
        BlockValue other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerBlockValuePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBlockId();
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        BlockValueType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        BlockValue $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "ServerBlockValuePacket(position=" + this.getPosition() + ", type=" + this.getType() + ", value=" + this.getValue() + ", blockId=" + this.getBlockId() + ")";
    }

    public ServerBlockValuePacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerBlockValuePacket(position, this.type, this.value, this.blockId);
    }

    public ServerBlockValuePacket withType(@NonNull BlockValueType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new ServerBlockValuePacket(this.position, type, this.value, this.blockId);
    }

    public ServerBlockValuePacket withValue(@NonNull BlockValue value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.value == value ? this : new ServerBlockValuePacket(this.position, this.type, value, this.blockId);
    }

    public ServerBlockValuePacket withBlockId(int blockId) {
        return this.blockId == blockId ? this : new ServerBlockValuePacket(this.position, this.type, this.value, blockId);
    }

    private ServerBlockValuePacket() {
    }

    public ServerBlockValuePacket(@NonNull Position position, @NonNull BlockValueType type, @NonNull BlockValue value, int blockId) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.position = position;
        this.type = type;
        this.value = value;
        this.blockId = blockId;
    }
}

