/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.world;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.UnmappedValueException;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.entity.player.BlockBreakStage;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerBlockBreakAnimPacket
implements Packet {
    private int breakerEntityId;
    @NonNull
    private Position position;
    @NonNull
    private BlockBreakStage stage;

    public void read(NetInput in) throws IOException {
        this.breakerEntityId = in.readVarInt();
        this.position = Position.read(in);
        try {
            this.stage = MagicValues.key(BlockBreakStage.class, in.readUnsignedByte());
        }
        catch (UnmappedValueException e) {
            this.stage = BlockBreakStage.RESET;
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.breakerEntityId);
        Position.write(out, this.position);
        out.writeByte(MagicValues.value(Integer.class, (Object)this.stage).intValue());
    }

    public boolean isPriority() {
        return false;
    }

    public int getBreakerEntityId() {
        return this.breakerEntityId;
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    @NonNull
    public BlockBreakStage getStage() {
        return this.stage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerBlockBreakAnimPacket)) {
            return false;
        }
        ServerBlockBreakAnimPacket other = (ServerBlockBreakAnimPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBreakerEntityId() != other.getBreakerEntityId()) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        BlockBreakStage this$stage = this.getStage();
        BlockBreakStage other$stage = other.getStage();
        return !(this$stage == null ? other$stage != null : !((Object)((Object)this$stage)).equals((Object)other$stage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerBlockBreakAnimPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBreakerEntityId();
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        BlockBreakStage $stage = this.getStage();
        result = result * 59 + ($stage == null ? 43 : ((Object)((Object)$stage)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerBlockBreakAnimPacket(breakerEntityId=" + this.getBreakerEntityId() + ", position=" + this.getPosition() + ", stage=" + (Object)((Object)this.getStage()) + ")";
    }

    public ServerBlockBreakAnimPacket withBreakerEntityId(int breakerEntityId) {
        return this.breakerEntityId == breakerEntityId ? this : new ServerBlockBreakAnimPacket(breakerEntityId, this.position, this.stage);
    }

    public ServerBlockBreakAnimPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerBlockBreakAnimPacket(this.breakerEntityId, position, this.stage);
    }

    public ServerBlockBreakAnimPacket withStage(@NonNull BlockBreakStage stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        return this.stage == stage ? this : new ServerBlockBreakAnimPacket(this.breakerEntityId, this.position, stage);
    }

    private ServerBlockBreakAnimPacket() {
    }

    public ServerBlockBreakAnimPacket(int breakerEntityId, @NonNull Position position, @NonNull BlockBreakStage stage) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        this.breakerEntityId = breakerEntityId;
        this.position = position;
        this.stage = stage;
    }
}

