/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.window;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.window.property.WindowProperty;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerWindowPropertyPacket
implements Packet {
    private int windowId;
    private int rawProperty;
    private int value;

    public ServerWindowPropertyPacket(int windowId, WindowProperty rawProperty, int value) {
        this(windowId, MagicValues.value(Integer.class, rawProperty), value);
    }

    public <T extends WindowProperty> T getProperty(Class<T> type) {
        return (T)((WindowProperty)MagicValues.key(type, this.value));
    }

    public void read(NetInput in) throws IOException {
        this.windowId = in.readUnsignedByte();
        this.rawProperty = in.readShort();
        this.value = in.readShort();
    }

    public void write(NetOutput out) throws IOException {
        out.writeByte(this.windowId);
        out.writeShort(this.rawProperty);
        out.writeShort(this.value);
    }

    public boolean isPriority() {
        return false;
    }

    public int getWindowId() {
        return this.windowId;
    }

    public int getRawProperty() {
        return this.rawProperty;
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerWindowPropertyPacket)) {
            return false;
        }
        ServerWindowPropertyPacket other = (ServerWindowPropertyPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWindowId() != other.getWindowId()) {
            return false;
        }
        if (this.getRawProperty() != other.getRawProperty()) {
            return false;
        }
        return this.getValue() == other.getValue();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerWindowPropertyPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWindowId();
        result = result * 59 + this.getRawProperty();
        result = result * 59 + this.getValue();
        return result;
    }

    public String toString() {
        return "ServerWindowPropertyPacket(windowId=" + this.getWindowId() + ", rawProperty=" + this.getRawProperty() + ", value=" + this.getValue() + ")";
    }

    public ServerWindowPropertyPacket withWindowId(int windowId) {
        return this.windowId == windowId ? this : new ServerWindowPropertyPacket(windowId, this.rawProperty, this.value);
    }

    public ServerWindowPropertyPacket withRawProperty(int rawProperty) {
        return this.rawProperty == rawProperty ? this : new ServerWindowPropertyPacket(this.windowId, rawProperty, this.value);
    }

    public ServerWindowPropertyPacket withValue(int value) {
        return this.value == value ? this : new ServerWindowPropertyPacket(this.windowId, this.rawProperty, value);
    }

    private ServerWindowPropertyPacket() {
    }

    public ServerWindowPropertyPacket(int windowId, int rawProperty, int value) {
        this.windowId = windowId;
        this.rawProperty = rawProperty;
        this.value = value;
    }
}

