/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.window;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ServerWindowItemsPacket
implements Packet {
    private int windowId;
    private int stateId;
    @NonNull
    private ItemStack[] items;
    private ItemStack carriedItem;

    public void read(NetInput in) throws IOException {
        this.windowId = in.readUnsignedByte();
        this.stateId = in.readVarInt();
        this.items = new ItemStack[in.readVarInt()];
        for (int index = 0; index < this.items.length; ++index) {
            this.items[index] = ItemStack.read(in);
        }
        this.carriedItem = ItemStack.read(in);
    }

    public void write(NetOutput out) throws IOException {
        out.writeByte(this.windowId);
        out.writeVarInt(this.stateId);
        out.writeVarInt(this.items.length);
        for (ItemStack item : this.items) {
            ItemStack.write(out, item);
        }
        ItemStack.write(out, this.carriedItem);
    }

    public boolean isPriority() {
        return false;
    }

    public int getWindowId() {
        return this.windowId;
    }

    public int getStateId() {
        return this.stateId;
    }

    @NonNull
    public ItemStack[] getItems() {
        return this.items;
    }

    public ItemStack getCarriedItem() {
        return this.carriedItem;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerWindowItemsPacket)) {
            return false;
        }
        ServerWindowItemsPacket other = (ServerWindowItemsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWindowId() != other.getWindowId()) {
            return false;
        }
        if (this.getStateId() != other.getStateId()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getItems(), other.getItems())) {
            return false;
        }
        ItemStack this$carriedItem = this.getCarriedItem();
        ItemStack other$carriedItem = other.getCarriedItem();
        return !(this$carriedItem == null ? other$carriedItem != null : !((Object)this$carriedItem).equals(other$carriedItem));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerWindowItemsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWindowId();
        result = result * 59 + this.getStateId();
        result = result * 59 + Arrays.deepHashCode(this.getItems());
        ItemStack $carriedItem = this.getCarriedItem();
        result = result * 59 + ($carriedItem == null ? 43 : ((Object)$carriedItem).hashCode());
        return result;
    }

    public String toString() {
        return "ServerWindowItemsPacket(windowId=" + this.getWindowId() + ", stateId=" + this.getStateId() + ", items=" + Arrays.deepToString(this.getItems()) + ", carriedItem=" + this.getCarriedItem() + ")";
    }

    public ServerWindowItemsPacket withWindowId(int windowId) {
        return this.windowId == windowId ? this : new ServerWindowItemsPacket(windowId, this.stateId, this.items, this.carriedItem);
    }

    public ServerWindowItemsPacket withStateId(int stateId) {
        return this.stateId == stateId ? this : new ServerWindowItemsPacket(this.windowId, stateId, this.items, this.carriedItem);
    }

    public ServerWindowItemsPacket withItems(@NonNull ItemStack[] items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        return this.items == items ? this : new ServerWindowItemsPacket(this.windowId, this.stateId, items, this.carriedItem);
    }

    public ServerWindowItemsPacket withCarriedItem(ItemStack carriedItem) {
        return this.carriedItem == carriedItem ? this : new ServerWindowItemsPacket(this.windowId, this.stateId, this.items, carriedItem);
    }

    private ServerWindowItemsPacket() {
    }

    public ServerWindowItemsPacket(int windowId, int stateId, @NonNull ItemStack[] items, ItemStack carriedItem) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        this.windowId = windowId;
        this.stateId = stateId;
        this.items = items;
        this.carriedItem = carriedItem;
    }
}

