/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.window;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.window.VillagerTrade;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ServerTradeListPacket
implements Packet {
    private int windowId;
    @NonNull
    private VillagerTrade[] trades;
    private int villagerLevel;
    private int experience;
    private boolean regularVillager;
    private boolean canRestock;

    public void read(NetInput in) throws IOException {
        this.windowId = in.readVarInt();
        byte size = in.readByte();
        this.trades = new VillagerTrade[size];
        for (int i = 0; i < this.trades.length; ++i) {
            ItemStack firstInput = ItemStack.read(in);
            ItemStack output = ItemStack.read(in);
            ItemStack secondInput = null;
            if (in.readBoolean()) {
                secondInput = ItemStack.read(in);
            }
            boolean tradeDisabled = in.readBoolean();
            int numUses = in.readInt();
            int maxUses = in.readInt();
            int xp = in.readInt();
            int specialPrice = in.readInt();
            float priceMultiplier = in.readFloat();
            int demand = in.readInt();
            this.trades[i] = new VillagerTrade(firstInput, secondInput, output, tradeDisabled, numUses, maxUses, xp, specialPrice, priceMultiplier, demand);
        }
        this.villagerLevel = in.readVarInt();
        this.experience = in.readVarInt();
        this.regularVillager = in.readBoolean();
        this.canRestock = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.windowId);
        out.writeByte(this.trades.length);
        for (int i = 0; i < this.trades.length; ++i) {
            VillagerTrade trade = this.trades[i];
            ItemStack.write(out, trade.getFirstInput());
            ItemStack.write(out, trade.getOutput());
            boolean hasSecondItem = trade.getSecondInput() != null;
            out.writeBoolean(hasSecondItem);
            if (hasSecondItem) {
                ItemStack.write(out, trade.getSecondInput());
            }
            out.writeBoolean(trade.isTradeDisabled());
            out.writeInt(trade.getNumUses());
            out.writeInt(trade.getMaxUses());
            out.writeInt(trade.getXp());
            out.writeInt(trade.getSpecialPrice());
            out.writeFloat(trade.getPriceMultiplier());
            out.writeInt(trade.getDemand());
        }
        out.writeVarInt(this.villagerLevel);
        out.writeVarInt(this.experience);
        out.writeBoolean(this.regularVillager);
        out.writeBoolean(this.canRestock);
    }

    public boolean isPriority() {
        return false;
    }

    public int getWindowId() {
        return this.windowId;
    }

    @NonNull
    public VillagerTrade[] getTrades() {
        return this.trades;
    }

    public int getVillagerLevel() {
        return this.villagerLevel;
    }

    public int getExperience() {
        return this.experience;
    }

    public boolean isRegularVillager() {
        return this.regularVillager;
    }

    public boolean isCanRestock() {
        return this.canRestock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerTradeListPacket)) {
            return false;
        }
        ServerTradeListPacket other = (ServerTradeListPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWindowId() != other.getWindowId()) {
            return false;
        }
        if (this.getVillagerLevel() != other.getVillagerLevel()) {
            return false;
        }
        if (this.getExperience() != other.getExperience()) {
            return false;
        }
        if (this.isRegularVillager() != other.isRegularVillager()) {
            return false;
        }
        if (this.isCanRestock() != other.isCanRestock()) {
            return false;
        }
        return Arrays.deepEquals(this.getTrades(), other.getTrades());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerTradeListPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWindowId();
        result = result * 59 + this.getVillagerLevel();
        result = result * 59 + this.getExperience();
        result = result * 59 + (this.isRegularVillager() ? 79 : 97);
        result = result * 59 + (this.isCanRestock() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getTrades());
        return result;
    }

    public String toString() {
        return "ServerTradeListPacket(windowId=" + this.getWindowId() + ", trades=" + Arrays.deepToString(this.getTrades()) + ", villagerLevel=" + this.getVillagerLevel() + ", experience=" + this.getExperience() + ", regularVillager=" + this.isRegularVillager() + ", canRestock=" + this.isCanRestock() + ")";
    }

    public ServerTradeListPacket withWindowId(int windowId) {
        return this.windowId == windowId ? this : new ServerTradeListPacket(windowId, this.trades, this.villagerLevel, this.experience, this.regularVillager, this.canRestock);
    }

    public ServerTradeListPacket withTrades(@NonNull VillagerTrade[] trades) {
        if (trades == null) {
            throw new NullPointerException("trades is marked non-null but is null");
        }
        return this.trades == trades ? this : new ServerTradeListPacket(this.windowId, trades, this.villagerLevel, this.experience, this.regularVillager, this.canRestock);
    }

    public ServerTradeListPacket withVillagerLevel(int villagerLevel) {
        return this.villagerLevel == villagerLevel ? this : new ServerTradeListPacket(this.windowId, this.trades, villagerLevel, this.experience, this.regularVillager, this.canRestock);
    }

    public ServerTradeListPacket withExperience(int experience) {
        return this.experience == experience ? this : new ServerTradeListPacket(this.windowId, this.trades, this.villagerLevel, experience, this.regularVillager, this.canRestock);
    }

    public ServerTradeListPacket withRegularVillager(boolean regularVillager) {
        return this.regularVillager == regularVillager ? this : new ServerTradeListPacket(this.windowId, this.trades, this.villagerLevel, this.experience, regularVillager, this.canRestock);
    }

    public ServerTradeListPacket withCanRestock(boolean canRestock) {
        return this.canRestock == canRestock ? this : new ServerTradeListPacket(this.windowId, this.trades, this.villagerLevel, this.experience, this.regularVillager, canRestock);
    }

    private ServerTradeListPacket() {
    }

    public ServerTradeListPacket(int windowId, @NonNull VillagerTrade[] trades, int villagerLevel, int experience, boolean regularVillager, boolean canRestock) {
        if (trades == null) {
            throw new NullPointerException("trades is marked non-null but is null");
        }
        this.windowId = windowId;
        this.trades = trades;
        this.villagerLevel = villagerLevel;
        this.experience = experience;
        this.regularVillager = regularVillager;
        this.canRestock = canRestock;
    }
}

