/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.window;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerSetSlotPacket
implements Packet {
    private int windowId;
    private int stateId;
    private int slot;
    private ItemStack item;

    public void read(NetInput in) throws IOException {
        this.windowId = in.readUnsignedByte();
        this.stateId = in.readVarInt();
        this.slot = in.readShort();
        this.item = ItemStack.read(in);
    }

    public void write(NetOutput out) throws IOException {
        out.writeByte(this.windowId);
        out.writeVarInt(this.stateId);
        out.writeShort(this.slot);
        ItemStack.write(out, this.item);
    }

    public boolean isPriority() {
        return false;
    }

    public int getWindowId() {
        return this.windowId;
    }

    public int getStateId() {
        return this.stateId;
    }

    public int getSlot() {
        return this.slot;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerSetSlotPacket)) {
            return false;
        }
        ServerSetSlotPacket other = (ServerSetSlotPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWindowId() != other.getWindowId()) {
            return false;
        }
        if (this.getStateId() != other.getStateId()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        ItemStack this$item = this.getItem();
        ItemStack other$item = other.getItem();
        return !(this$item == null ? other$item != null : !((Object)this$item).equals(other$item));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerSetSlotPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWindowId();
        result = result * 59 + this.getStateId();
        result = result * 59 + this.getSlot();
        ItemStack $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : ((Object)$item).hashCode());
        return result;
    }

    public String toString() {
        return "ServerSetSlotPacket(windowId=" + this.getWindowId() + ", stateId=" + this.getStateId() + ", slot=" + this.getSlot() + ", item=" + this.getItem() + ")";
    }

    public ServerSetSlotPacket withWindowId(int windowId) {
        return this.windowId == windowId ? this : new ServerSetSlotPacket(windowId, this.stateId, this.slot, this.item);
    }

    public ServerSetSlotPacket withStateId(int stateId) {
        return this.stateId == stateId ? this : new ServerSetSlotPacket(this.windowId, stateId, this.slot, this.item);
    }

    public ServerSetSlotPacket withSlot(int slot) {
        return this.slot == slot ? this : new ServerSetSlotPacket(this.windowId, this.stateId, slot, this.item);
    }

    public ServerSetSlotPacket withItem(ItemStack item) {
        return this.item == item ? this : new ServerSetSlotPacket(this.windowId, this.stateId, this.slot, item);
    }

    private ServerSetSlotPacket() {
    }

    public ServerSetSlotPacket(int windowId, int stateId, int slot, ItemStack item) {
        this.windowId = windowId;
        this.stateId = stateId;
        this.slot = slot;
        this.item = item;
    }
}

