/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.window;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerPreparedCraftingGridPacket
implements Packet {
    private int windowId;
    @NonNull
    private String recipeId;

    public void read(NetInput in) throws IOException {
        this.windowId = in.readByte();
        this.recipeId = in.readString();
    }

    public void write(NetOutput out) throws IOException {
        out.writeByte(this.windowId);
        out.writeString(this.recipeId);
    }

    public boolean isPriority() {
        return false;
    }

    public int getWindowId() {
        return this.windowId;
    }

    @NonNull
    public String getRecipeId() {
        return this.recipeId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerPreparedCraftingGridPacket)) {
            return false;
        }
        ServerPreparedCraftingGridPacket other = (ServerPreparedCraftingGridPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWindowId() != other.getWindowId()) {
            return false;
        }
        String this$recipeId = this.getRecipeId();
        String other$recipeId = other.getRecipeId();
        return !(this$recipeId == null ? other$recipeId != null : !this$recipeId.equals(other$recipeId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerPreparedCraftingGridPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWindowId();
        String $recipeId = this.getRecipeId();
        result = result * 59 + ($recipeId == null ? 43 : $recipeId.hashCode());
        return result;
    }

    public String toString() {
        return "ServerPreparedCraftingGridPacket(windowId=" + this.getWindowId() + ", recipeId=" + this.getRecipeId() + ")";
    }

    public ServerPreparedCraftingGridPacket withWindowId(int windowId) {
        return this.windowId == windowId ? this : new ServerPreparedCraftingGridPacket(windowId, this.recipeId);
    }

    public ServerPreparedCraftingGridPacket withRecipeId(@NonNull String recipeId) {
        if (recipeId == null) {
            throw new NullPointerException("recipeId is marked non-null but is null");
        }
        return this.recipeId == recipeId ? this : new ServerPreparedCraftingGridPacket(this.windowId, recipeId);
    }

    private ServerPreparedCraftingGridPacket() {
    }

    public ServerPreparedCraftingGridPacket(int windowId, @NonNull String recipeId) {
        if (recipeId == null) {
            throw new NullPointerException("recipeId is marked non-null but is null");
        }
        this.windowId = windowId;
        this.recipeId = recipeId;
    }
}

