/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.window;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.window.WindowType;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerOpenWindowPacket
implements Packet {
    private int windowId;
    @NonNull
    private WindowType type;
    @NonNull
    private String name;

    public void read(NetInput in) throws IOException {
        this.windowId = in.readVarInt();
        this.type = MagicValues.key(WindowType.class, in.readVarInt());
        this.name = in.readString();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.windowId);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.type).intValue());
        out.writeString(this.name);
    }

    public boolean isPriority() {
        return false;
    }

    public int getWindowId() {
        return this.windowId;
    }

    @NonNull
    public WindowType getType() {
        return this.type;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerOpenWindowPacket)) {
            return false;
        }
        ServerOpenWindowPacket other = (ServerOpenWindowPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWindowId() != other.getWindowId()) {
            return false;
        }
        WindowType this$type = this.getType();
        WindowType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerOpenWindowPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWindowId();
        WindowType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "ServerOpenWindowPacket(windowId=" + this.getWindowId() + ", type=" + (Object)((Object)this.getType()) + ", name=" + this.getName() + ")";
    }

    public ServerOpenWindowPacket withWindowId(int windowId) {
        return this.windowId == windowId ? this : new ServerOpenWindowPacket(windowId, this.type, this.name);
    }

    public ServerOpenWindowPacket withType(@NonNull WindowType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new ServerOpenWindowPacket(this.windowId, type, this.name);
    }

    public ServerOpenWindowPacket withName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new ServerOpenWindowPacket(this.windowId, this.type, name);
    }

    private ServerOpenWindowPacket() {
    }

    public ServerOpenWindowPacket(int windowId, @NonNull WindowType type, @NonNull String name) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.windowId = windowId;
        this.type = type;
        this.name = name;
    }
}

