/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.window;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerOpenHorseWindowPacket
implements Packet {
    private int windowId;
    private int numberOfSlots;
    private int entityId;

    public void read(NetInput in) throws IOException {
        this.windowId = in.readByte();
        this.numberOfSlots = in.readVarInt();
        this.entityId = in.readInt();
    }

    public void write(NetOutput out) throws IOException {
        out.writeByte(this.windowId);
        out.writeVarInt(this.numberOfSlots);
        out.writeInt(this.entityId);
    }

    public boolean isPriority() {
        return false;
    }

    public int getWindowId() {
        return this.windowId;
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerOpenHorseWindowPacket)) {
            return false;
        }
        ServerOpenHorseWindowPacket other = (ServerOpenHorseWindowPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWindowId() != other.getWindowId()) {
            return false;
        }
        if (this.getNumberOfSlots() != other.getNumberOfSlots()) {
            return false;
        }
        return this.getEntityId() == other.getEntityId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerOpenHorseWindowPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWindowId();
        result = result * 59 + this.getNumberOfSlots();
        result = result * 59 + this.getEntityId();
        return result;
    }

    public String toString() {
        return "ServerOpenHorseWindowPacket(windowId=" + this.getWindowId() + ", numberOfSlots=" + this.getNumberOfSlots() + ", entityId=" + this.getEntityId() + ")";
    }

    public ServerOpenHorseWindowPacket withWindowId(int windowId) {
        return this.windowId == windowId ? this : new ServerOpenHorseWindowPacket(windowId, this.numberOfSlots, this.entityId);
    }

    public ServerOpenHorseWindowPacket withNumberOfSlots(int numberOfSlots) {
        return this.numberOfSlots == numberOfSlots ? this : new ServerOpenHorseWindowPacket(this.windowId, numberOfSlots, this.entityId);
    }

    public ServerOpenHorseWindowPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerOpenHorseWindowPacket(this.windowId, this.numberOfSlots, entityId);
    }

    private ServerOpenHorseWindowPacket() {
    }

    public ServerOpenHorseWindowPacket(int windowId, int numberOfSlots, int entityId) {
        this.windowId = windowId;
        this.numberOfSlots = numberOfSlots;
        this.entityId = entityId;
    }
}

