/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.scoreboard;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.scoreboard.ScoreboardAction;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerUpdateScorePacket
implements Packet {
    @NonNull
    private String entry;
    @NonNull
    private ScoreboardAction action;
    @NonNull
    private String objective;
    private int value;

    public ServerUpdateScorePacket(@NonNull String entry, @NonNull String objective) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.entry = entry;
        this.action = ScoreboardAction.REMOVE;
        this.objective = objective;
    }

    public ServerUpdateScorePacket(@NonNull String entry, @NonNull String objective, int value) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.entry = entry;
        this.action = ScoreboardAction.ADD_OR_UPDATE;
        this.objective = objective;
        this.value = value;
    }

    public void read(NetInput in) throws IOException {
        this.entry = in.readString();
        this.action = MagicValues.key(ScoreboardAction.class, in.readVarInt());
        this.objective = in.readString();
        if (this.action == ScoreboardAction.ADD_OR_UPDATE) {
            this.value = in.readVarInt();
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeString(this.entry);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.action).intValue());
        out.writeString(this.objective);
        if (this.action == ScoreboardAction.ADD_OR_UPDATE) {
            out.writeVarInt(this.value);
        }
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public String getEntry() {
        return this.entry;
    }

    @NonNull
    public ScoreboardAction getAction() {
        return this.action;
    }

    @NonNull
    public String getObjective() {
        return this.objective;
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerUpdateScorePacket)) {
            return false;
        }
        ServerUpdateScorePacket other = (ServerUpdateScorePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getValue() != other.getValue()) {
            return false;
        }
        String this$entry = this.getEntry();
        String other$entry = other.getEntry();
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        ScoreboardAction this$action = this.getAction();
        ScoreboardAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        String this$objective = this.getObjective();
        String other$objective = other.getObjective();
        return !(this$objective == null ? other$objective != null : !this$objective.equals(other$objective));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerUpdateScorePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getValue();
        String $entry = this.getEntry();
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        ScoreboardAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        String $objective = this.getObjective();
        result = result * 59 + ($objective == null ? 43 : $objective.hashCode());
        return result;
    }

    public String toString() {
        return "ServerUpdateScorePacket(entry=" + this.getEntry() + ", action=" + (Object)((Object)this.getAction()) + ", objective=" + this.getObjective() + ", value=" + this.getValue() + ")";
    }

    public ServerUpdateScorePacket withEntry(@NonNull String entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return this.entry == entry ? this : new ServerUpdateScorePacket(entry, this.action, this.objective, this.value);
    }

    public ServerUpdateScorePacket withAction(@NonNull ScoreboardAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ServerUpdateScorePacket(this.entry, action, this.objective, this.value);
    }

    public ServerUpdateScorePacket withObjective(@NonNull String objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        return this.objective == objective ? this : new ServerUpdateScorePacket(this.entry, this.action, objective, this.value);
    }

    public ServerUpdateScorePacket withValue(int value) {
        return this.value == value ? this : new ServerUpdateScorePacket(this.entry, this.action, this.objective, value);
    }

    private ServerUpdateScorePacket() {
    }

    private ServerUpdateScorePacket(@NonNull String entry, @NonNull ScoreboardAction action, @NonNull String objective, int value) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.entry = entry;
        this.action = action;
        this.objective = objective;
        this.value = value;
    }
}

