/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.scoreboard;

import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.UnmappedValueException;
import com.github.steveice10.mc.protocol.data.game.scoreboard.CollisionRule;
import com.github.steveice10.mc.protocol.data.game.scoreboard.NameTagVisibility;
import com.github.steveice10.mc.protocol.data.game.scoreboard.TeamAction;
import com.github.steveice10.mc.protocol.data.game.scoreboard.TeamColor;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class ServerTeamPacket
implements Packet {
    @NonNull
    private String teamName;
    @NonNull
    private TeamAction action;
    private Component displayName;
    private Component prefix;
    private Component suffix;
    private boolean friendlyFire;
    private boolean seeFriendlyInvisibles;
    private NameTagVisibility nameTagVisibility;
    private CollisionRule collisionRule;
    private TeamColor color;
    private String[] players;

    public ServerTeamPacket(@NonNull String teamName) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        this.teamName = teamName;
        this.action = TeamAction.REMOVE;
    }

    public ServerTeamPacket(@NonNull String teamName, @NonNull Component displayName, @NonNull Component prefix, @NonNull Component suffix, boolean friendlyFire, boolean seeFriendlyInvisibles, @NonNull NameTagVisibility nameTagVisibility, @NonNull CollisionRule collisionRule, @NonNull TeamColor color) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (nameTagVisibility == null) {
            throw new NullPointerException("nameTagVisibility is marked non-null but is null");
        }
        if (collisionRule == null) {
            throw new NullPointerException("collisionRule is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        this.teamName = teamName;
        this.action = TeamAction.UPDATE;
        this.displayName = displayName;
        this.prefix = prefix;
        this.suffix = suffix;
        this.friendlyFire = friendlyFire;
        this.seeFriendlyInvisibles = seeFriendlyInvisibles;
        this.nameTagVisibility = nameTagVisibility;
        this.collisionRule = collisionRule;
        this.color = color;
    }

    public ServerTeamPacket(@NonNull String teamName, @NonNull TeamAction action, @NonNull String[] players) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (players == null) {
            throw new NullPointerException("players is marked non-null but is null");
        }
        if (action != TeamAction.ADD_PLAYER && action != TeamAction.REMOVE_PLAYER) {
            throw new IllegalArgumentException("(name, action, players) constructor only valid for adding and removing players.");
        }
        this.teamName = teamName;
        this.action = action;
        this.players = Arrays.copyOf(players, players.length);
    }

    public ServerTeamPacket(@NonNull String teamName, @NonNull Component displayName, @NonNull Component prefix, @NonNull Component suffix, boolean friendlyFire, boolean seeFriendlyInvisibles, @NonNull NameTagVisibility nameTagVisibility, @NonNull CollisionRule collisionRule, @NonNull TeamColor color, @NonNull String[] players) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (nameTagVisibility == null) {
            throw new NullPointerException("nameTagVisibility is marked non-null but is null");
        }
        if (collisionRule == null) {
            throw new NullPointerException("collisionRule is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (players == null) {
            throw new NullPointerException("players is marked non-null but is null");
        }
        this.teamName = teamName;
        this.action = TeamAction.CREATE;
        this.displayName = displayName;
        this.prefix = prefix;
        this.suffix = suffix;
        this.friendlyFire = friendlyFire;
        this.seeFriendlyInvisibles = seeFriendlyInvisibles;
        this.nameTagVisibility = nameTagVisibility;
        this.collisionRule = collisionRule;
        this.color = color;
        this.players = Arrays.copyOf(players, players.length);
    }

    public void read(NetInput in) throws IOException {
        this.teamName = in.readString();
        this.action = MagicValues.key(TeamAction.class, in.readByte());
        if (this.action == TeamAction.CREATE || this.action == TeamAction.UPDATE) {
            this.displayName = DefaultComponentSerializer.get().deserialize((Object)in.readString());
            byte flags = in.readByte();
            this.friendlyFire = (flags & 1) != 0;
            this.seeFriendlyInvisibles = (flags & 2) != 0;
            this.nameTagVisibility = MagicValues.key(NameTagVisibility.class, in.readString());
            this.collisionRule = MagicValues.key(CollisionRule.class, in.readString());
            try {
                this.color = MagicValues.key(TeamColor.class, in.readVarInt());
            }
            catch (UnmappedValueException e) {
                this.color = TeamColor.NONE;
            }
            this.prefix = DefaultComponentSerializer.get().deserialize((Object)in.readString());
            this.suffix = DefaultComponentSerializer.get().deserialize((Object)in.readString());
        }
        if (this.action == TeamAction.CREATE || this.action == TeamAction.ADD_PLAYER || this.action == TeamAction.REMOVE_PLAYER) {
            this.players = new String[in.readVarInt()];
            for (int index = 0; index < this.players.length; ++index) {
                this.players[index] = in.readString();
            }
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeString(this.teamName);
        out.writeByte(MagicValues.value(Integer.class, (Object)this.action).intValue());
        if (this.action == TeamAction.CREATE || this.action == TeamAction.UPDATE) {
            out.writeString((String)DefaultComponentSerializer.get().serialize(this.displayName));
            out.writeByte((this.friendlyFire ? 1 : 0) | (this.seeFriendlyInvisibles ? 2 : 0));
            out.writeString(MagicValues.value(String.class, (Object)this.nameTagVisibility));
            out.writeString(MagicValues.value(String.class, (Object)this.collisionRule));
            out.writeVarInt(MagicValues.value(Integer.class, (Object)this.color).intValue());
            out.writeString((String)DefaultComponentSerializer.get().serialize(this.prefix));
            out.writeString((String)DefaultComponentSerializer.get().serialize(this.suffix));
        }
        if (this.action == TeamAction.CREATE || this.action == TeamAction.ADD_PLAYER || this.action == TeamAction.REMOVE_PLAYER) {
            out.writeVarInt(this.players.length);
            for (String player : this.players) {
                if (player == null) continue;
                out.writeString(player);
            }
        }
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public String getTeamName() {
        return this.teamName;
    }

    @NonNull
    public TeamAction getAction() {
        return this.action;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public Component getPrefix() {
        return this.prefix;
    }

    public Component getSuffix() {
        return this.suffix;
    }

    public boolean isFriendlyFire() {
        return this.friendlyFire;
    }

    public boolean isSeeFriendlyInvisibles() {
        return this.seeFriendlyInvisibles;
    }

    public NameTagVisibility getNameTagVisibility() {
        return this.nameTagVisibility;
    }

    public CollisionRule getCollisionRule() {
        return this.collisionRule;
    }

    public TeamColor getColor() {
        return this.color;
    }

    public String[] getPlayers() {
        return this.players;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerTeamPacket)) {
            return false;
        }
        ServerTeamPacket other = (ServerTeamPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFriendlyFire() != other.isFriendlyFire()) {
            return false;
        }
        if (this.isSeeFriendlyInvisibles() != other.isSeeFriendlyInvisibles()) {
            return false;
        }
        String this$teamName = this.getTeamName();
        String other$teamName = other.getTeamName();
        if (this$teamName == null ? other$teamName != null : !this$teamName.equals(other$teamName)) {
            return false;
        }
        TeamAction this$action = this.getAction();
        TeamAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        Component this$displayName = this.getDisplayName();
        Component other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Component this$prefix = this.getPrefix();
        Component other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        Component this$suffix = this.getSuffix();
        Component other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        NameTagVisibility this$nameTagVisibility = this.getNameTagVisibility();
        NameTagVisibility other$nameTagVisibility = other.getNameTagVisibility();
        if (this$nameTagVisibility == null ? other$nameTagVisibility != null : !((Object)((Object)this$nameTagVisibility)).equals((Object)other$nameTagVisibility)) {
            return false;
        }
        CollisionRule this$collisionRule = this.getCollisionRule();
        CollisionRule other$collisionRule = other.getCollisionRule();
        if (this$collisionRule == null ? other$collisionRule != null : !((Object)((Object)this$collisionRule)).equals((Object)other$collisionRule)) {
            return false;
        }
        TeamColor this$color = this.getColor();
        TeamColor other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)((Object)this$color)).equals((Object)other$color)) {
            return false;
        }
        return Arrays.deepEquals(this.getPlayers(), other.getPlayers());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerTeamPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFriendlyFire() ? 79 : 97);
        result = result * 59 + (this.isSeeFriendlyInvisibles() ? 79 : 97);
        String $teamName = this.getTeamName();
        result = result * 59 + ($teamName == null ? 43 : $teamName.hashCode());
        TeamAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        Component $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Component $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        Component $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        NameTagVisibility $nameTagVisibility = this.getNameTagVisibility();
        result = result * 59 + ($nameTagVisibility == null ? 43 : ((Object)((Object)$nameTagVisibility)).hashCode());
        CollisionRule $collisionRule = this.getCollisionRule();
        result = result * 59 + ($collisionRule == null ? 43 : ((Object)((Object)$collisionRule)).hashCode());
        TeamColor $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)((Object)$color)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPlayers());
        return result;
    }

    public String toString() {
        return "ServerTeamPacket(teamName=" + this.getTeamName() + ", action=" + (Object)((Object)this.getAction()) + ", displayName=" + this.getDisplayName() + ", prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ", friendlyFire=" + this.isFriendlyFire() + ", seeFriendlyInvisibles=" + this.isSeeFriendlyInvisibles() + ", nameTagVisibility=" + (Object)((Object)this.getNameTagVisibility()) + ", collisionRule=" + (Object)((Object)this.getCollisionRule()) + ", color=" + (Object)((Object)this.getColor()) + ", players=" + Arrays.deepToString(this.getPlayers()) + ")";
    }

    public ServerTeamPacket withTeamName(@NonNull String teamName) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        return this.teamName == teamName ? this : new ServerTeamPacket(teamName, this.action, this.displayName, this.prefix, this.suffix, this.friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, this.color, this.players);
    }

    public ServerTeamPacket withAction(@NonNull TeamAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ServerTeamPacket(this.teamName, action, this.displayName, this.prefix, this.suffix, this.friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, this.color, this.players);
    }

    public ServerTeamPacket withDisplayName(Component displayName) {
        return this.displayName == displayName ? this : new ServerTeamPacket(this.teamName, this.action, displayName, this.prefix, this.suffix, this.friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, this.color, this.players);
    }

    public ServerTeamPacket withPrefix(Component prefix) {
        return this.prefix == prefix ? this : new ServerTeamPacket(this.teamName, this.action, this.displayName, prefix, this.suffix, this.friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, this.color, this.players);
    }

    public ServerTeamPacket withSuffix(Component suffix) {
        return this.suffix == suffix ? this : new ServerTeamPacket(this.teamName, this.action, this.displayName, this.prefix, suffix, this.friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, this.color, this.players);
    }

    public ServerTeamPacket withFriendlyFire(boolean friendlyFire) {
        return this.friendlyFire == friendlyFire ? this : new ServerTeamPacket(this.teamName, this.action, this.displayName, this.prefix, this.suffix, friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, this.color, this.players);
    }

    public ServerTeamPacket withSeeFriendlyInvisibles(boolean seeFriendlyInvisibles) {
        return this.seeFriendlyInvisibles == seeFriendlyInvisibles ? this : new ServerTeamPacket(this.teamName, this.action, this.displayName, this.prefix, this.suffix, this.friendlyFire, seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, this.color, this.players);
    }

    public ServerTeamPacket withNameTagVisibility(NameTagVisibility nameTagVisibility) {
        return this.nameTagVisibility == nameTagVisibility ? this : new ServerTeamPacket(this.teamName, this.action, this.displayName, this.prefix, this.suffix, this.friendlyFire, this.seeFriendlyInvisibles, nameTagVisibility, this.collisionRule, this.color, this.players);
    }

    public ServerTeamPacket withCollisionRule(CollisionRule collisionRule) {
        return this.collisionRule == collisionRule ? this : new ServerTeamPacket(this.teamName, this.action, this.displayName, this.prefix, this.suffix, this.friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, collisionRule, this.color, this.players);
    }

    public ServerTeamPacket withColor(TeamColor color) {
        return this.color == color ? this : new ServerTeamPacket(this.teamName, this.action, this.displayName, this.prefix, this.suffix, this.friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, color, this.players);
    }

    public ServerTeamPacket withPlayers(String[] players) {
        return this.players == players ? this : new ServerTeamPacket(this.teamName, this.action, this.displayName, this.prefix, this.suffix, this.friendlyFire, this.seeFriendlyInvisibles, this.nameTagVisibility, this.collisionRule, this.color, players);
    }

    private ServerTeamPacket() {
    }

    private ServerTeamPacket(@NonNull String teamName, @NonNull TeamAction action, Component displayName, Component prefix, Component suffix, boolean friendlyFire, boolean seeFriendlyInvisibles, NameTagVisibility nameTagVisibility, CollisionRule collisionRule, TeamColor color, String[] players) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.teamName = teamName;
        this.action = action;
        this.displayName = displayName;
        this.prefix = prefix;
        this.suffix = suffix;
        this.friendlyFire = friendlyFire;
        this.seeFriendlyInvisibles = seeFriendlyInvisibles;
        this.nameTagVisibility = nameTagVisibility;
        this.collisionRule = collisionRule;
        this.color = color;
        this.players = players;
    }
}

