/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.scoreboard;

import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.scoreboard.ObjectiveAction;
import com.github.steveice10.mc.protocol.data.game.scoreboard.ScoreType;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class ServerScoreboardObjectivePacket
implements Packet {
    @NonNull
    private String name;
    @NonNull
    private ObjectiveAction action;
    private Component displayName;
    private ScoreType type;

    public ServerScoreboardObjectivePacket(@NonNull String name) {
        this(name, ObjectiveAction.REMOVE, null, null);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    public ServerScoreboardObjectivePacket(@NonNull String name, @NonNull ObjectiveAction action, Component displayName, ScoreType type) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (!(action != ObjectiveAction.ADD && action != ObjectiveAction.UPDATE || displayName != null && type != null)) {
            throw new IllegalArgumentException("ADD and UPDATE actions require display name and type.");
        }
        this.name = name;
        this.action = action;
        this.displayName = displayName;
        this.type = type;
    }

    public void read(NetInput in) throws IOException {
        this.name = in.readString();
        this.action = MagicValues.key(ObjectiveAction.class, in.readByte());
        if (this.action == ObjectiveAction.ADD || this.action == ObjectiveAction.UPDATE) {
            this.displayName = DefaultComponentSerializer.get().deserialize((Object)in.readString());
            this.type = MagicValues.key(ScoreType.class, in.readVarInt());
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeString(this.name);
        out.writeByte(MagicValues.value(Integer.class, (Object)this.action).intValue());
        if (this.action == ObjectiveAction.ADD || this.action == ObjectiveAction.UPDATE) {
            out.writeString((String)DefaultComponentSerializer.get().serialize(this.displayName));
            out.writeVarInt(MagicValues.value(Integer.class, (Object)this.type).intValue());
        }
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public ObjectiveAction getAction() {
        return this.action;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public ScoreType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerScoreboardObjectivePacket)) {
            return false;
        }
        ServerScoreboardObjectivePacket other = (ServerScoreboardObjectivePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ObjectiveAction this$action = this.getAction();
        ObjectiveAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        Component this$displayName = this.getDisplayName();
        Component other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        ScoreType this$type = this.getType();
        ScoreType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerScoreboardObjectivePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ObjectiveAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        Component $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        ScoreType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerScoreboardObjectivePacket(name=" + this.getName() + ", action=" + (Object)((Object)this.getAction()) + ", displayName=" + this.getDisplayName() + ", type=" + (Object)((Object)this.getType()) + ")";
    }

    public ServerScoreboardObjectivePacket withName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new ServerScoreboardObjectivePacket(name, this.action, this.displayName, this.type);
    }

    public ServerScoreboardObjectivePacket withAction(@NonNull ObjectiveAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ServerScoreboardObjectivePacket(this.name, action, this.displayName, this.type);
    }

    public ServerScoreboardObjectivePacket withDisplayName(Component displayName) {
        return this.displayName == displayName ? this : new ServerScoreboardObjectivePacket(this.name, this.action, displayName, this.type);
    }

    public ServerScoreboardObjectivePacket withType(ScoreType type) {
        return this.type == type ? this : new ServerScoreboardObjectivePacket(this.name, this.action, this.displayName, type);
    }

    private ServerScoreboardObjectivePacket() {
    }
}

