/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.scoreboard;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.scoreboard.ScoreboardPosition;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerDisplayScoreboardPacket
implements Packet {
    @NonNull
    private ScoreboardPosition position;
    @NonNull
    private String name;

    public void read(NetInput in) throws IOException {
        this.position = MagicValues.key(ScoreboardPosition.class, in.readByte());
        this.name = in.readString();
    }

    public void write(NetOutput out) throws IOException {
        out.writeByte(MagicValues.value(Integer.class, (Object)this.position).intValue());
        out.writeString(this.name);
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public ScoreboardPosition getPosition() {
        return this.position;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerDisplayScoreboardPacket)) {
            return false;
        }
        ServerDisplayScoreboardPacket other = (ServerDisplayScoreboardPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScoreboardPosition this$position = this.getPosition();
        ScoreboardPosition other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)((Object)this$position)).equals((Object)other$position)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerDisplayScoreboardPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScoreboardPosition $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)((Object)$position)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "ServerDisplayScoreboardPacket(position=" + (Object)((Object)this.getPosition()) + ", name=" + this.getName() + ")";
    }

    public ServerDisplayScoreboardPacket withPosition(@NonNull ScoreboardPosition position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerDisplayScoreboardPacket(position, this.name);
    }

    public ServerDisplayScoreboardPacket withName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new ServerDisplayScoreboardPacket(this.position, name);
    }

    private ServerDisplayScoreboardPacket() {
    }

    public ServerDisplayScoreboardPacket(@NonNull ScoreboardPosition position, @NonNull String name) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.position = position;
        this.name = name;
    }
}

