/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity.spawn;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.type.EntityType;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;

public class ServerSpawnLivingEntityPacket
implements Packet {
    private int entityId;
    @NonNull
    private UUID uuid;
    @NonNull
    private EntityType type;
    private double x;
    private double y;
    private double z;
    private float pitch;
    private float yaw;
    private float headYaw;
    private double motionX;
    private double motionY;
    private double motionZ;

    public void read(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.uuid = in.readUUID();
        this.type = MagicValues.key(EntityType.class, in.readVarInt());
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.yaw = (float)(in.readByte() * 360) / 256.0f;
        this.pitch = (float)(in.readByte() * 360) / 256.0f;
        this.headYaw = (float)(in.readByte() * 360) / 256.0f;
        this.motionX = (double)in.readShort() / 8000.0;
        this.motionY = (double)in.readShort() / 8000.0;
        this.motionZ = (double)in.readShort() / 8000.0;
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeUUID(this.uuid);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.type).intValue());
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeByte((int)((byte)(this.yaw * 256.0f / 360.0f)));
        out.writeByte((int)((byte)(this.pitch * 256.0f / 360.0f)));
        out.writeByte((int)((byte)(this.headYaw * 256.0f / 360.0f)));
        out.writeShort((int)(this.motionX * 8000.0));
        out.writeShort((int)(this.motionY * 8000.0));
        out.writeShort((int)(this.motionZ * 8000.0));
    }

    public boolean isPriority() {
        return false;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NonNull
    public EntityType getType() {
        return this.type;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getHeadYaw() {
        return this.headYaw;
    }

    public double getMotionX() {
        return this.motionX;
    }

    public double getMotionY() {
        return this.motionY;
    }

    public double getMotionZ() {
        return this.motionZ;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerSpawnLivingEntityPacket)) {
            return false;
        }
        ServerSpawnLivingEntityPacket other = (ServerSpawnLivingEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getHeadYaw(), other.getHeadYaw()) != 0) {
            return false;
        }
        if (Double.compare(this.getMotionX(), other.getMotionX()) != 0) {
            return false;
        }
        if (Double.compare(this.getMotionY(), other.getMotionY()) != 0) {
            return false;
        }
        if (Double.compare(this.getMotionZ(), other.getMotionZ()) != 0) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        EntityType this$type = this.getType();
        EntityType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerSpawnLivingEntityPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getHeadYaw());
        long $motionX = Double.doubleToLongBits(this.getMotionX());
        result = result * 59 + (int)($motionX >>> 32 ^ $motionX);
        long $motionY = Double.doubleToLongBits(this.getMotionY());
        result = result * 59 + (int)($motionY >>> 32 ^ $motionY);
        long $motionZ = Double.doubleToLongBits(this.getMotionZ());
        result = result * 59 + (int)($motionZ >>> 32 ^ $motionZ);
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        EntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerSpawnLivingEntityPacket(entityId=" + this.getEntityId() + ", uuid=" + this.getUuid() + ", type=" + (Object)((Object)this.getType()) + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", pitch=" + this.getPitch() + ", yaw=" + this.getYaw() + ", headYaw=" + this.getHeadYaw() + ", motionX=" + this.getMotionX() + ", motionY=" + this.getMotionY() + ", motionZ=" + this.getMotionZ() + ")";
    }

    public ServerSpawnLivingEntityPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerSpawnLivingEntityPacket(entityId, this.uuid, this.type, this.x, this.y, this.z, this.pitch, this.yaw, this.headYaw, this.motionX, this.motionY, this.motionZ);
    }

    public ServerSpawnLivingEntityPacket withUuid(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        return this.uuid == uuid ? this : new ServerSpawnLivingEntityPacket(this.entityId, uuid, this.type, this.x, this.y, this.z, this.pitch, this.yaw, this.headYaw, this.motionX, this.motionY, this.motionZ);
    }

    public ServerSpawnLivingEntityPacket withType(@NonNull EntityType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new ServerSpawnLivingEntityPacket(this.entityId, this.uuid, type, this.x, this.y, this.z, this.pitch, this.yaw, this.headYaw, this.motionX, this.motionY, this.motionZ);
    }

    public ServerSpawnLivingEntityPacket withX(double x) {
        return this.x == x ? this : new ServerSpawnLivingEntityPacket(this.entityId, this.uuid, this.type, x, this.y, this.z, this.pitch, this.yaw, this.headYaw, this.motionX, this.motionY, this.motionZ);
    }

    public ServerSpawnLivingEntityPacket withY(double y) {
        return this.y == y ? this : new ServerSpawnLivingEntityPacket(this.entityId, this.uuid, this.type, this.x, y, this.z, this.pitch, this.yaw, this.headYaw, this.motionX, this.motionY, this.motionZ);
    }

    public ServerSpawnLivingEntityPacket withZ(double z) {
        return this.z == z ? this : new ServerSpawnLivingEntityPacket(this.entityId, this.uuid, this.type, this.x, this.y, z, this.pitch, this.yaw, this.headYaw, this.motionX, this.motionY, this.motionZ);
    }

    public ServerSpawnLivingEntityPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ServerSpawnLivingEntityPacket(this.entityId, this.uuid, this.type, this.x, this.y, this.z, pitch, this.yaw, this.headYaw, this.motionX, this.motionY, this.motionZ);
    }

    public ServerSpawnLivingEntityPacket withYaw(float yaw) {
        return this.yaw == yaw ? this : new ServerSpawnLivingEntityPacket(this.entityId, this.uuid, this.type, this.x, this.y, this.z, this.pitch, yaw, this.headYaw, this.motionX, this.motionY, this.motionZ);
    }

    public ServerSpawnLivingEntityPacket withHeadYaw(float headYaw) {
        return this.headYaw == headYaw ? this : new ServerSpawnLivingEntityPacket(this.entityId, this.uuid, this.type, this.x, this.y, this.z, this.pitch, this.yaw, headYaw, this.motionX, this.motionY, this.motionZ);
    }

    public ServerSpawnLivingEntityPacket withMotionX(double motionX) {
        return this.motionX == motionX ? this : new ServerSpawnLivingEntityPacket(this.entityId, this.uuid, this.type, this.x, this.y, this.z, this.pitch, this.yaw, this.headYaw, motionX, this.motionY, this.motionZ);
    }

    public ServerSpawnLivingEntityPacket withMotionY(double motionY) {
        return this.motionY == motionY ? this : new ServerSpawnLivingEntityPacket(this.entityId, this.uuid, this.type, this.x, this.y, this.z, this.pitch, this.yaw, this.headYaw, this.motionX, motionY, this.motionZ);
    }

    public ServerSpawnLivingEntityPacket withMotionZ(double motionZ) {
        return this.motionZ == motionZ ? this : new ServerSpawnLivingEntityPacket(this.entityId, this.uuid, this.type, this.x, this.y, this.z, this.pitch, this.yaw, this.headYaw, this.motionX, this.motionY, motionZ);
    }

    private ServerSpawnLivingEntityPacket() {
    }

    public ServerSpawnLivingEntityPacket(int entityId, @NonNull UUID uuid, @NonNull EntityType type, double x, double y, double z, float pitch, float yaw, float headYaw, double motionX, double motionY, double motionZ) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.entityId = entityId;
        this.uuid = uuid;
        this.type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
        this.headYaw = headYaw;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }
}

