/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity.spawn;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerSpawnExpOrbPacket
implements Packet {
    private int entityId;
    private double x;
    private double y;
    private double z;
    private int exp;

    public void read(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.exp = in.readShort();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeShort(this.exp);
    }

    public boolean isPriority() {
        return false;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getExp() {
        return this.exp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerSpawnExpOrbPacket)) {
            return false;
        }
        ServerSpawnExpOrbPacket other = (ServerSpawnExpOrbPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        return this.getExp() == other.getExp();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerSpawnExpOrbPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + this.getExp();
        return result;
    }

    public String toString() {
        return "ServerSpawnExpOrbPacket(entityId=" + this.getEntityId() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", exp=" + this.getExp() + ")";
    }

    public ServerSpawnExpOrbPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerSpawnExpOrbPacket(entityId, this.x, this.y, this.z, this.exp);
    }

    public ServerSpawnExpOrbPacket withX(double x) {
        return this.x == x ? this : new ServerSpawnExpOrbPacket(this.entityId, x, this.y, this.z, this.exp);
    }

    public ServerSpawnExpOrbPacket withY(double y) {
        return this.y == y ? this : new ServerSpawnExpOrbPacket(this.entityId, this.x, y, this.z, this.exp);
    }

    public ServerSpawnExpOrbPacket withZ(double z) {
        return this.z == z ? this : new ServerSpawnExpOrbPacket(this.entityId, this.x, this.y, z, this.exp);
    }

    public ServerSpawnExpOrbPacket withExp(int exp) {
        return this.exp == exp ? this : new ServerSpawnExpOrbPacket(this.entityId, this.x, this.y, this.z, exp);
    }

    private ServerSpawnExpOrbPacket() {
    }

    public ServerSpawnExpOrbPacket(int entityId, double x, double y, double z, int exp) {
        this.entityId = entityId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.exp = exp;
    }
}

