/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity.player;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerPlayerSetExperiencePacket
implements Packet {
    private float experience;
    private int level;
    private int totalExperience;

    public void read(NetInput in) throws IOException {
        this.experience = in.readFloat();
        this.level = in.readVarInt();
        this.totalExperience = in.readVarInt();
    }

    public void write(NetOutput out) throws IOException {
        out.writeFloat(this.experience);
        out.writeVarInt(this.level);
        out.writeVarInt(this.totalExperience);
    }

    public boolean isPriority() {
        return false;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getLevel() {
        return this.level;
    }

    public int getTotalExperience() {
        return this.totalExperience;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerPlayerSetExperiencePacket)) {
            return false;
        }
        ServerPlayerSetExperiencePacket other = (ServerPlayerSetExperiencePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getExperience(), other.getExperience()) != 0) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        return this.getTotalExperience() == other.getTotalExperience();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerPlayerSetExperiencePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getExperience());
        result = result * 59 + this.getLevel();
        result = result * 59 + this.getTotalExperience();
        return result;
    }

    public String toString() {
        return "ServerPlayerSetExperiencePacket(experience=" + this.getExperience() + ", level=" + this.getLevel() + ", totalExperience=" + this.getTotalExperience() + ")";
    }

    public ServerPlayerSetExperiencePacket withExperience(float experience) {
        return this.experience == experience ? this : new ServerPlayerSetExperiencePacket(experience, this.level, this.totalExperience);
    }

    public ServerPlayerSetExperiencePacket withLevel(int level) {
        return this.level == level ? this : new ServerPlayerSetExperiencePacket(this.experience, level, this.totalExperience);
    }

    public ServerPlayerSetExperiencePacket withTotalExperience(int totalExperience) {
        return this.totalExperience == totalExperience ? this : new ServerPlayerSetExperiencePacket(this.experience, this.level, totalExperience);
    }

    private ServerPlayerSetExperiencePacket() {
    }

    public ServerPlayerSetExperiencePacket(float experience, int level, int totalExperience) {
        this.experience = experience;
        this.level = level;
        this.totalExperience = totalExperience;
    }
}

