/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity.player;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.RotationOrigin;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerPlayerFacingPacket
implements Packet {
    @NonNull
    private RotationOrigin origin;
    private double x;
    private double y;
    private double z;
    private int targetEntityId;
    private RotationOrigin targetEntityOrigin;

    public ServerPlayerFacingPacket(RotationOrigin origin, double x, double y, double z) {
        this(origin, x, y, z, 0, null);
    }

    public void read(NetInput in) throws IOException {
        this.origin = MagicValues.key(RotationOrigin.class, in.readVarInt());
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        if (in.readBoolean()) {
            this.targetEntityId = in.readVarInt();
            this.targetEntityOrigin = MagicValues.key(RotationOrigin.class, in.readVarInt());
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.origin).intValue());
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        if (this.targetEntityOrigin != null) {
            out.writeBoolean(true);
            out.writeVarInt(this.targetEntityId);
            out.writeVarInt(MagicValues.value(Integer.class, (Object)this.targetEntityOrigin).intValue());
        } else {
            out.writeBoolean(false);
        }
    }

    public boolean isPriority() {
        return false;
    }

    @NonNull
    public RotationOrigin getOrigin() {
        return this.origin;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getTargetEntityId() {
        return this.targetEntityId;
    }

    public RotationOrigin getTargetEntityOrigin() {
        return this.targetEntityOrigin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerPlayerFacingPacket)) {
            return false;
        }
        ServerPlayerFacingPacket other = (ServerPlayerFacingPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (this.getTargetEntityId() != other.getTargetEntityId()) {
            return false;
        }
        RotationOrigin this$origin = this.getOrigin();
        RotationOrigin other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !((Object)((Object)this$origin)).equals((Object)other$origin)) {
            return false;
        }
        RotationOrigin this$targetEntityOrigin = this.getTargetEntityOrigin();
        RotationOrigin other$targetEntityOrigin = other.getTargetEntityOrigin();
        return !(this$targetEntityOrigin == null ? other$targetEntityOrigin != null : !((Object)((Object)this$targetEntityOrigin)).equals((Object)other$targetEntityOrigin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerPlayerFacingPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + this.getTargetEntityId();
        RotationOrigin $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : ((Object)((Object)$origin)).hashCode());
        RotationOrigin $targetEntityOrigin = this.getTargetEntityOrigin();
        result = result * 59 + ($targetEntityOrigin == null ? 43 : ((Object)((Object)$targetEntityOrigin)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerPlayerFacingPacket(origin=" + (Object)((Object)this.getOrigin()) + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", targetEntityId=" + this.getTargetEntityId() + ", targetEntityOrigin=" + (Object)((Object)this.getTargetEntityOrigin()) + ")";
    }

    public ServerPlayerFacingPacket withOrigin(@NonNull RotationOrigin origin) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        return this.origin == origin ? this : new ServerPlayerFacingPacket(origin, this.x, this.y, this.z, this.targetEntityId, this.targetEntityOrigin);
    }

    public ServerPlayerFacingPacket withX(double x) {
        return this.x == x ? this : new ServerPlayerFacingPacket(this.origin, x, this.y, this.z, this.targetEntityId, this.targetEntityOrigin);
    }

    public ServerPlayerFacingPacket withY(double y) {
        return this.y == y ? this : new ServerPlayerFacingPacket(this.origin, this.x, y, this.z, this.targetEntityId, this.targetEntityOrigin);
    }

    public ServerPlayerFacingPacket withZ(double z) {
        return this.z == z ? this : new ServerPlayerFacingPacket(this.origin, this.x, this.y, z, this.targetEntityId, this.targetEntityOrigin);
    }

    public ServerPlayerFacingPacket withTargetEntityId(int targetEntityId) {
        return this.targetEntityId == targetEntityId ? this : new ServerPlayerFacingPacket(this.origin, this.x, this.y, this.z, targetEntityId, this.targetEntityOrigin);
    }

    public ServerPlayerFacingPacket withTargetEntityOrigin(RotationOrigin targetEntityOrigin) {
        return this.targetEntityOrigin == targetEntityOrigin ? this : new ServerPlayerFacingPacket(this.origin, this.x, this.y, this.z, this.targetEntityId, targetEntityOrigin);
    }

    private ServerPlayerFacingPacket() {
    }

    public ServerPlayerFacingPacket(@NonNull RotationOrigin origin, double x, double y, double z, int targetEntityId, RotationOrigin targetEntityOrigin) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        this.origin = origin;
        this.x = x;
        this.y = y;
        this.z = z;
        this.targetEntityId = targetEntityId;
        this.targetEntityOrigin = targetEntityOrigin;
    }
}

