/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity.player;

import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import net.kyori.adventure.text.Component;

public class ServerPlayerCombatKillPacket
implements Packet {
    private int playerId;
    private int killerId;
    private Component message;

    public void read(NetInput in) throws IOException {
        this.playerId = in.readVarInt();
        this.killerId = in.readInt();
        this.message = DefaultComponentSerializer.get().deserialize((Object)in.readString());
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.playerId);
        out.writeInt(this.killerId);
        out.writeString((String)DefaultComponentSerializer.get().serialize(this.message));
    }

    public boolean isPriority() {
        return false;
    }

    public int getPlayerId() {
        return this.playerId;
    }

    public int getKillerId() {
        return this.killerId;
    }

    public Component getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerPlayerCombatKillPacket)) {
            return false;
        }
        ServerPlayerCombatKillPacket other = (ServerPlayerCombatKillPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPlayerId() != other.getPlayerId()) {
            return false;
        }
        if (this.getKillerId() != other.getKillerId()) {
            return false;
        }
        Component this$message = this.getMessage();
        Component other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerPlayerCombatKillPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPlayerId();
        result = result * 59 + this.getKillerId();
        Component $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "ServerPlayerCombatKillPacket(playerId=" + this.getPlayerId() + ", killerId=" + this.getKillerId() + ", message=" + this.getMessage() + ")";
    }

    public ServerPlayerCombatKillPacket withPlayerId(int playerId) {
        return this.playerId == playerId ? this : new ServerPlayerCombatKillPacket(playerId, this.killerId, this.message);
    }

    public ServerPlayerCombatKillPacket withKillerId(int killerId) {
        return this.killerId == killerId ? this : new ServerPlayerCombatKillPacket(this.playerId, killerId, this.message);
    }

    public ServerPlayerCombatKillPacket withMessage(Component message) {
        return this.message == message ? this : new ServerPlayerCombatKillPacket(this.playerId, this.killerId, message);
    }

    private ServerPlayerCombatKillPacket() {
    }

    public ServerPlayerCombatKillPacket(int playerId, int killerId, Component message) {
        this.playerId = playerId;
        this.killerId = killerId;
        this.message = message;
    }
}

