/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity.player;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerPlayerCombatEndPacket
implements Packet {
    private int killerId;
    private int duration;

    public void read(NetInput in) throws IOException {
        this.duration = in.readVarInt();
        this.killerId = in.readInt();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.duration);
        out.writeInt(this.killerId);
    }

    public boolean isPriority() {
        return false;
    }

    public int getKillerId() {
        return this.killerId;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerPlayerCombatEndPacket)) {
            return false;
        }
        ServerPlayerCombatEndPacket other = (ServerPlayerCombatEndPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getKillerId() != other.getKillerId()) {
            return false;
        }
        return this.getDuration() == other.getDuration();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerPlayerCombatEndPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getKillerId();
        result = result * 59 + this.getDuration();
        return result;
    }

    public String toString() {
        return "ServerPlayerCombatEndPacket(killerId=" + this.getKillerId() + ", duration=" + this.getDuration() + ")";
    }

    public ServerPlayerCombatEndPacket withKillerId(int killerId) {
        return this.killerId == killerId ? this : new ServerPlayerCombatEndPacket(killerId, this.duration);
    }

    public ServerPlayerCombatEndPacket withDuration(int duration) {
        return this.duration == duration ? this : new ServerPlayerCombatEndPacket(this.killerId, duration);
    }

    private ServerPlayerCombatEndPacket() {
    }

    public ServerPlayerCombatEndPacket(int killerId, int duration) {
        this.killerId = killerId;
        this.duration = duration;
    }
}

