/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerEntityTeleportPacket
implements Packet {
    private int entityId;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private boolean onGround;

    public void read(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.yaw = (float)(in.readByte() * 360) / 256.0f;
        this.pitch = (float)(in.readByte() * 360) / 256.0f;
        this.onGround = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeByte((int)((byte)(this.yaw * 256.0f / 360.0f)));
        out.writeByte((int)((byte)(this.pitch * 256.0f / 360.0f)));
        out.writeBoolean(this.onGround);
    }

    public boolean isPriority() {
        return false;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerEntityTeleportPacket)) {
            return false;
        }
        ServerEntityTeleportPacket other = (ServerEntityTeleportPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        return this.isOnGround() == other.isOnGround();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerEntityTeleportPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        result = result * 59 + (this.isOnGround() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ServerEntityTeleportPacket(entityId=" + this.getEntityId() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ", onGround=" + this.isOnGround() + ")";
    }

    public ServerEntityTeleportPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerEntityTeleportPacket(entityId, this.x, this.y, this.z, this.yaw, this.pitch, this.onGround);
    }

    public ServerEntityTeleportPacket withX(double x) {
        return this.x == x ? this : new ServerEntityTeleportPacket(this.entityId, x, this.y, this.z, this.yaw, this.pitch, this.onGround);
    }

    public ServerEntityTeleportPacket withY(double y) {
        return this.y == y ? this : new ServerEntityTeleportPacket(this.entityId, this.x, y, this.z, this.yaw, this.pitch, this.onGround);
    }

    public ServerEntityTeleportPacket withZ(double z) {
        return this.z == z ? this : new ServerEntityTeleportPacket(this.entityId, this.x, this.y, z, this.yaw, this.pitch, this.onGround);
    }

    public ServerEntityTeleportPacket withYaw(float yaw) {
        return this.yaw == yaw ? this : new ServerEntityTeleportPacket(this.entityId, this.x, this.y, this.z, yaw, this.pitch, this.onGround);
    }

    public ServerEntityTeleportPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ServerEntityTeleportPacket(this.entityId, this.x, this.y, this.z, this.yaw, pitch, this.onGround);
    }

    public ServerEntityTeleportPacket withOnGround(boolean onGround) {
        return this.onGround == onGround ? this : new ServerEntityTeleportPacket(this.entityId, this.x, this.y, this.z, this.yaw, this.pitch, onGround);
    }

    private ServerEntityTeleportPacket() {
    }

    public ServerEntityTeleportPacket(int entityId, double x, double y, double z, float yaw, float pitch, boolean onGround) {
        this.entityId = entityId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.onGround = onGround;
    }
}

