/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.EntityStatus;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerEntityStatusPacket
implements Packet {
    protected int entityId;
    @NonNull
    protected EntityStatus status;

    public void read(NetInput in) throws IOException {
        this.entityId = in.readInt();
        this.status = MagicValues.key(EntityStatus.class, in.readByte());
    }

    public void write(NetOutput out) throws IOException {
        out.writeInt(this.entityId);
        out.writeByte(MagicValues.value(Integer.class, (Object)this.status).intValue());
    }

    public boolean isPriority() {
        return false;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public EntityStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerEntityStatusPacket)) {
            return false;
        }
        ServerEntityStatusPacket other = (ServerEntityStatusPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        EntityStatus this$status = this.getStatus();
        EntityStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerEntityStatusPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        EntityStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerEntityStatusPacket(entityId=" + this.getEntityId() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    public ServerEntityStatusPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerEntityStatusPacket(entityId, this.status);
    }

    public ServerEntityStatusPacket withStatus(@NonNull EntityStatus status) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        return this.status == status ? this : new ServerEntityStatusPacket(this.entityId, status);
    }

    private ServerEntityStatusPacket() {
    }

    public ServerEntityStatusPacket(int entityId, @NonNull EntityStatus status) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.entityId = entityId;
        this.status = status;
    }
}

