/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ServerEntitySetPassengersPacket
implements Packet {
    private int entityId;
    @NonNull
    private int[] passengerIds;

    public void read(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.passengerIds = new int[in.readVarInt()];
        for (int index = 0; index < this.passengerIds.length; ++index) {
            this.passengerIds[index] = in.readVarInt();
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeVarInt(this.passengerIds.length);
        for (int entityId : this.passengerIds) {
            out.writeVarInt(entityId);
        }
    }

    public boolean isPriority() {
        return false;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public int[] getPassengerIds() {
        return this.passengerIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerEntitySetPassengersPacket)) {
            return false;
        }
        ServerEntitySetPassengersPacket other = (ServerEntitySetPassengersPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        return Arrays.equals(this.getPassengerIds(), other.getPassengerIds());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerEntitySetPassengersPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + Arrays.hashCode(this.getPassengerIds());
        return result;
    }

    public String toString() {
        return "ServerEntitySetPassengersPacket(entityId=" + this.getEntityId() + ", passengerIds=" + Arrays.toString(this.getPassengerIds()) + ")";
    }

    public ServerEntitySetPassengersPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerEntitySetPassengersPacket(entityId, this.passengerIds);
    }

    public ServerEntitySetPassengersPacket withPassengerIds(@NonNull int[] passengerIds) {
        if (passengerIds == null) {
            throw new NullPointerException("passengerIds is marked non-null but is null");
        }
        return this.passengerIds == passengerIds ? this : new ServerEntitySetPassengersPacket(this.entityId, passengerIds);
    }

    private ServerEntitySetPassengersPacket() {
    }

    public ServerEntitySetPassengersPacket(int entityId, @NonNull int[] passengerIds) {
        if (passengerIds == null) {
            throw new NullPointerException("passengerIds is marked non-null but is null");
        }
        this.entityId = entityId;
        this.passengerIds = passengerIds;
    }
}

