/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.server.entity;

import com.github.steveice10.mc.protocol.data.game.entity.Effect;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerEntityRemoveEffectPacket
implements Packet {
    private int entityId;
    @NonNull
    private Effect effect;

    public void read(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.effect = Effect.fromNetworkId(in.readUnsignedByte());
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeByte(Effect.toNetworkId(this.effect));
    }

    public boolean isPriority() {
        return false;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public Effect getEffect() {
        return this.effect;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerEntityRemoveEffectPacket)) {
            return false;
        }
        ServerEntityRemoveEffectPacket other = (ServerEntityRemoveEffectPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        Effect this$effect = this.getEffect();
        Effect other$effect = other.getEffect();
        return !(this$effect == null ? other$effect != null : !((Object)((Object)this$effect)).equals((Object)other$effect));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerEntityRemoveEffectPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        Effect $effect = this.getEffect();
        result = result * 59 + ($effect == null ? 43 : ((Object)((Object)$effect)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerEntityRemoveEffectPacket(entityId=" + this.getEntityId() + ", effect=" + (Object)((Object)this.getEffect()) + ")";
    }

    public ServerEntityRemoveEffectPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerEntityRemoveEffectPacket(entityId, this.effect);
    }

    public ServerEntityRemoveEffectPacket withEffect(@NonNull Effect effect) {
        if (effect == null) {
            throw new NullPointerException("effect is marked non-null but is null");
        }
        return this.effect == effect ? this : new ServerEntityRemoveEffectPacket(this.entityId, effect);
    }

    private ServerEntityRemoveEffectPacket() {
    }

    public ServerEntityRemoveEffectPacket(int entityId, @NonNull Effect effect) {
        if (effect == null) {
            throw new NullPointerException("effect is marked non-null but is null");
        }
        this.entityId = entityId;
        this.effect = effect;
    }
}

